/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items.ability;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.api.AbilityExecuteEvent;
import me.boboballoon.innovativeitems.functions.condition.ActiveCondition;
import me.boboballoon.innovativeitems.functions.context.FlexibleContext;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.BlockContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.ItemContext;
import me.boboballoon.innovativeitems.functions.keyword.ActiveKeyword;
import me.boboballoon.innovativeitems.items.ability.trigger.AbilityTrigger;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class Ability {
    private final String identifier;
    private final ImmutableList<ActiveKeyword> keywords;
    private final ImmutableList<ActiveCondition> conditions;
    private final AbilityTrigger<?, ?> trigger;
    private final String providedTriggerIdentifier;

    public Ability(@NotNull String identifier, @NotNull ImmutableList<ActiveKeyword> keywords, @NotNull ImmutableList<ActiveCondition> conditions, @NotNull AbilityTrigger<?, ?> trigger, @NotNull String providedTriggerIdentifier) {
        this.identifier = identifier;
        this.keywords = keywords;
        this.conditions = conditions;
        this.trigger = trigger;
        this.providedTriggerIdentifier = providedTriggerIdentifier;
        this.trigger.init(this);
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public ImmutableList<ActiveKeyword> getKeywords() {
        return this.keywords;
    }

    @NotNull
    public AbilityTrigger<?, ?> getTrigger() {
        return this.trigger;
    }

    @NotNull
    public ImmutableList<ActiveCondition> getConditions() {
        return this.conditions;
    }

    @NotNull
    public String getProvidedTriggerIdentifier() {
        return this.providedTriggerIdentifier;
    }

    public boolean execute(@NotNull RuntimeContext context) {
        if (this != context.getAbility()) {
            throw new IllegalArgumentException("An instance of RuntimeContext has been passed to an ability that does not reflect the context!");
        }
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("The ability execute method cannot be called from the main thread!");
        }
        if (this.shouldWrapContext(context)) {
            context = FlexibleContext.wrap(context);
        } else if (!AbilityTrigger.isCompatible(context.getAbilityTrigger(), this.trigger)) {
            LogUtil.log(LogUtil.Level.NOISE, "Ability: " + this.identifier + " failed to execute due to an incompatible runtime context. (if safety is not an issue try setting the strict field in the main config file to false)");
            return false;
        }
        AbilityExecuteEvent event = new AbilityExecuteEvent(context);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            LogUtil.log(LogUtil.Level.NOISE, "Ability: " + this.identifier + " failed to execute due to the ability execute event being cancelled.");
            return false;
        }
        for (ActiveCondition condition : this.conditions) {
            Boolean value = (Boolean)condition.execute(context);
            if (value == null) {
                LogUtil.log(LogUtil.Level.SEVERE, "There was an error trying to execute the " + this.identifier + " ability because the condition " + condition.getBase().getIdentifier() + " returned null!");
                return false;
            }
            if (value.booleanValue() != condition.isInverted()) continue;
            LogUtil.log(LogUtil.Level.NOISE, "Condition: " + condition.getBase().getIdentifier() + " failed on the " + this.identifier + " ability.");
            return false;
        }
        for (ActiveKeyword keyword : this.keywords) {
            keyword.execute(context);
        }
        return true;
    }

    public boolean execute(@NotNull Player player) {
        RuntimeContext context = new RuntimeContext(player, this);
        return this.execute(context);
    }

    private boolean shouldWrapContext(@NotNull RuntimeContext context) {
        if (InnovativeItems.getInstance().getConfigManager().isStrict()) {
            return false;
        }
        return !(context instanceof EntityContext) || !(context instanceof BlockContext) || !(context instanceof ItemContext);
    }
}

