/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.items.InnovativeCache;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.BeaconInventory;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.LoomInventory;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.StonecutterInventory;
import org.bukkit.inventory.meta.Damageable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemDefender
implements Listener {
    private final Set<Class<? extends Inventory>> blacklistedInventories = Sets.newHashSet((Object[])new Class[]{AnvilInventory.class, BeaconInventory.class, BrewerInventory.class, CartographyInventory.class, EnchantingInventory.class, GrindstoneInventory.class, LoomInventory.class, MerchantInventory.class, SmithingInventory.class, StonecutterInventory.class});
    private boolean enabled;

    public ItemDefender(boolean enabled) {
        this.enabled = enabled;
        LogUtil.log(LogUtil.Level.INFO, "New item defender initialized!");
    }

    @NotNull
    public Set<Class<? extends Inventory>> getBlacklistedInventories() {
        return this.blacklistedInventories;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.enabled) {
            return;
        }
        InnovativeCache cache = InnovativeItems.getInstance().getItemCache();
        Inventory clicked = event.getClickedInventory();
        Inventory top = event.getInventory();
        CustomItem slot = cache.fromItemStack(event.getCurrentItem());
        CustomItem cursor = cache.fromItemStack(event.getCursor());
        if (clicked == null || slot != null && !slot.shouldUpdateItem() || cursor != null && !cursor.shouldUpdateItem() || !this.contains(clicked.getClass()) && (event.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY || top.getType() == InventoryType.CRAFTING || !this.contains(top.getClass())) || slot == null && cursor == null) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!this.enabled) {
            return;
        }
        InnovativeCache cache = InnovativeItems.getInstance().getItemCache();
        Inventory inventory = event.getInventory();
        CustomItem cursor = cache.fromItemStack(event.getOldCursor());
        if (cursor == null || cursor != null && !cursor.shouldUpdateItem() || !this.contains(inventory.getClass())) {
            return;
        }
        HashSet<Inventory> inventories = new HashSet<Inventory>();
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            inventories.add(event.getView().getInventory(slot));
        }
        if (inventories.size() > 1 || this.contains(inventories.toArray()[0].getClass())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        CustomItem selected;
        if (!this.enabled) {
            return;
        }
        InnovativeCache cache = InnovativeItems.getInstance().getItemCache();
        CustomItem one = cache.fromItemStack(event.getInventory().getItem(0));
        CustomItem two = cache.fromItemStack(event.getInventory().getItem(1));
        CustomItem result = cache.fromItemStack(event.getResult());
        if (result == null || one == null && two == null) {
            return;
        }
        CustomItem customItem = one == result ? one : (selected = two == result ? two : null);
        if (selected == null) {
            return;
        }
        ItemStack base = event.getInventory().getItem(one == result ? 0 : 1);
        if (!(base.getItemMeta() instanceof Damageable)) {
            return;
        }
        Damageable data = (Damageable)base.getItemMeta();
        Damageable resultData = (Damageable)event.getResult().getItemMeta();
        if (data.getDamage() != resultData.getDamage()) {
            event.setResult(null);
            event.getViewers().stream().map(human -> (Player)human).forEach(Player::updateInventory);
        }
    }

    private boolean contains(@NotNull Class<? extends Inventory> clazz) {
        for (Class<? extends Inventory> type : this.blacklistedInventories) {
            if (!type.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Class<? extends Inventory> findClass(@NotNull String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            return null;
        }
    }
}

