/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items;

import com.google.common.collect.ImmutableList;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InnovativeCache {
    private final Map<String, Ability> abilities = new LinkedHashMap<String, Ability>();
    private final Map<String, CustomItem> items = new LinkedHashMap<String, CustomItem>();

    public void registerAbility(@NotNull Ability ability) {
        String name = ability.getIdentifier();
        if (this.contains(name)) {
            LogUtil.log(LogUtil.Level.WARNING, "Ability with the name of " + name + ", is already registered! Skipping...");
            return;
        }
        this.abilities.put(name, ability);
    }

    public void registerItem(@NotNull CustomItem item) {
        String name = item.getIdentifier();
        if (this.contains(name)) {
            LogUtil.log(LogUtil.Level.WARNING, "Item with the name of " + name + ", is already registered! Skipping...");
            return;
        }
        this.items.put(name, item);
        if (item.getRecipes() == null) {
            return;
        }
        Runnable task = () -> {
            for (Recipe recipe : item.getRecipes()) {
                try {
                    Bukkit.addRecipe((Recipe)recipe);
                }
                catch (IllegalStateException e) {
                    LogUtil.log(LogUtil.Level.INFO, "It seems like there was a duplicate recipe registered for an item... Normally this is not a problem but if a bug occurs this might be the cause...");
                    if (InnovativeItems.getInstance().getConfigManager().getDebugLevel() < LogUtil.Level.DEV.getDebugLevel()) continue;
                    e.printStackTrace();
                }
            }
        };
        if (Bukkit.isPrimaryThread()) {
            task.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)InnovativeItems.getInstance(), task);
        }
    }

    @Nullable
    public Ability getAbility(@NotNull String name) {
        return this.abilities.get(name);
    }

    @Nullable
    public CustomItem getItem(@NotNull String name) {
        return this.items.get(name);
    }

    @Nullable
    public CustomItem fromItemStack(@Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        return this.fromNBTItem(new NBTItem(item));
    }

    @Nullable
    public CustomItem fromNBTItem(@NotNull NBTItem item) {
        if (!item.hasKey("innovativeplugin-customitem").booleanValue()) {
            return null;
        }
        return this.getItem(item.getString("innovativeplugin-customitem-id"));
    }

    @NotNull
    public Collection<CustomItem> fromItemStacks(@NotNull Collection<ItemStack> items, boolean includeNulls) {
        ArrayList<CustomItem> output = new ArrayList<CustomItem>();
        for (ItemStack stack : items) {
            CustomItem item = this.fromItemStack(stack);
            if (item == null && !includeNulls) continue;
            output.add(item);
        }
        return !output.isEmpty() ? output : Collections.emptyList();
    }

    @NotNull
    public Collection<CustomItem> fromItemStacks(@NotNull Collection<ItemStack> items) {
        return this.fromItemStacks(items, false);
    }

    public void clearCache() {
        this.abilities.clear();
        this.items.clear();
    }

    public boolean contains(@NotNull String name) {
        return this.abilities.containsKey(name) || this.items.containsKey(name);
    }

    @NotNull
    public ImmutableList<Ability> getAbilities() {
        return ImmutableList.copyOf(this.abilities.values());
    }

    @NotNull
    public ImmutableList<CustomItem> getItems() {
        return ImmutableList.copyOf(this.items.values());
    }
}

