/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.items;

import de.tr7zw.nbtapi.NBTItem;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.util.DurabilityUtil;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GarbageCollector
implements Listener {
    private boolean enabled = true;
    private boolean shouldUpdate;
    private boolean shouldDelete;

    public GarbageCollector(boolean shouldUpdate, boolean shouldDelete) {
        this.shouldUpdate = shouldUpdate;
        this.shouldDelete = shouldDelete;
        LogUtil.log(LogUtil.Level.INFO, "New garbage collector initialized!");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean shouldUpdateItems() {
        return this.shouldUpdate;
    }

    public void setShouldUpdate(boolean shouldUpdate) {
        this.shouldUpdate = shouldUpdate;
    }

    public boolean shouldDeleteItems() {
        return this.shouldDelete;
    }

    public void setShouldDelete(boolean shouldDelete) {
        this.shouldDelete = shouldDelete;
    }

    public void cleanInventory(@NotNull Inventory inventory, boolean async) {
        if (!this.enabled) {
            LogUtil.log(LogUtil.Level.WARNING, "The garbage collector tried to run while disabled!");
            return;
        }
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)InnovativeItems.getInstance(), () -> this.cleanup(inventory.getContents(), inventory.getType(), inventory.getLocation()));
        } else if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)InnovativeItems.getInstance(), () -> this.cleanup(inventory.getContents(), inventory.getType(), inventory.getLocation()));
        } else {
            this.cleanup(inventory.getContents(), inventory.getType(), inventory.getLocation());
        }
    }

    public void cleanAllPlayerInventories(boolean async) {
        if (!this.enabled) {
            LogUtil.log(LogUtil.Level.WARNING, "The garbage collector tried to run while disabled!");
            return;
        }
        LogUtil.log(LogUtil.Level.INFO, "Starting player inventory cleanup...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.cleanInventory((Inventory)player.getInventory(), async);
        }
        LogUtil.log(LogUtil.Level.INFO, "Player inventory cleanup complete!");
    }

    private void cleanup(@Nullable ItemStack item, @NotNull InventoryType type, @NotNull Location location) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        NBTItem nbt = new NBTItem(item, true);
        if (!nbt.hasKey("innovativeplugin-customitem").booleanValue()) {
            return;
        }
        String identifier = nbt.getString("innovativeplugin-customitem-id");
        CustomItem customItem = InnovativeItems.getInstance().getItemCache().getItem(identifier);
        if (this.shouldDelete && customItem == null) {
            LogUtil.log(LogUtil.Level.NOISE, "Deleting custom item " + identifier + " in " + type.name() + " at " + location.toString());
            item.setAmount(0);
            return;
        }
        if (!this.shouldUpdate || customItem == null || !customItem.shouldUpdateItem() || GarbageCollector.isSame(customItem, item)) {
            return;
        }
        ItemStack customItemData = customItem.getItemStack();
        Integer durability = DurabilityUtil.getDurability(item);
        Material typeBefore = item.getType();
        item.setType(customItemData.getType());
        item.setData(customItemData.getData());
        item.setItemMeta(customItemData.getItemMeta());
        if (typeBefore == customItemData.getType() && durability != null && durability <= customItem.getMaxDurability()) {
            DurabilityUtil.setDurability(item, durability);
        }
        LogUtil.log(LogUtil.Level.NOISE, "Updating item " + customItem.getIdentifier() + " in " + type.name() + " at " + location.toString());
    }

    private void cleanup(@NotNull ItemStack[] items, @NotNull InventoryType type, @NotNull Location location) {
        for (ItemStack item : items) {
            this.cleanup(item, type, location);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        LogUtil.log(LogUtil.Level.NOISE, "Cleaning up " + player.getName() + "'s inventory because they joined the game!");
        this.cleanInventory((Inventory)player.getInventory(), true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onInventoryOpen(InventoryOpenEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory.getHolder() instanceof Container)) {
            return;
        }
        LogUtil.log(LogUtil.Level.NOISE, "Cleaning up container inventory that " + event.getPlayer().getName() + " opened!");
        this.cleanInventory(inventory, true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onItemPickup(EntityPickupItemEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        PlayerInventory inventory = player.getInventory();
        ItemStack item = event.getItem().getItemStack();
        NBTItem nbt = new NBTItem(item);
        if (!nbt.hasKey("innovativeplugin-customitem").booleanValue()) {
            return;
        }
        LogUtil.log(LogUtil.Level.NOISE, "Cleaning up " + player.getName() + "'s inventory because they picked up a custom item!");
        this.cleanInventory((Inventory)inventory, true);
    }

    private static boolean isSame(@NotNull CustomItem item, @NotNull ItemStack two) {
        ItemStack one = item.getItemStack();
        if (one.getType() != two.getType() || !two.hasItemMeta()) {
            return false;
        }
        ItemStack copyOne = new ItemStack(one);
        ItemStack copyTwo = new ItemStack(two);
        NBTItem nbtOne = new NBTItem(copyOne, true);
        NBTItem nbtTwo = new NBTItem(copyTwo, true);
        nbtOne.setInteger("Damage", Integer.valueOf(1));
        nbtTwo.setInteger("Damage", Integer.valueOf(1));
        nbtOne.setInteger("innovativeplugin-customitem-durability", Integer.valueOf(1));
        nbtTwo.setInteger("innovativeplugin-customitem-durability", Integer.valueOf(1));
        return copyOne.isSimilar(copyTwo);
    }
}

