/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.keyword.builtin;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.BlockContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import me.boboballoon.innovativeitems.functions.keyword.Keyword;
import org.bukkit.Location;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class LightningKeyword
extends Keyword {
    public LightningKeyword() {
        super("lightning", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY, FunctionTargeter.BLOCK), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.DOUBLE, "damage amount"));
    }

    @Override
    protected void calling(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        Location location = null;
        FunctionTargeter rawLocation = (FunctionTargeter)((Object)arguments.get(0));
        if (rawLocation == FunctionTargeter.PLAYER) {
            location = context.getPlayer().getLocation();
        }
        if (rawLocation == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            location = entityContext.getEntity().getLocation();
        }
        if (rawLocation == FunctionTargeter.BLOCK && context instanceof BlockContext) {
            BlockContext blockContext = (BlockContext)((Object)context);
            location = blockContext.getBlock().getLocation();
        }
        location.getWorld().strikeLightningEffect(location);
        double damage = (Double)arguments.get(1);
        if (damage <= 0.0) {
            return;
        }
        Collection entities = location.getWorld().getNearbyEntities(location, 5.0, 5.0, 5.0, entity -> entity instanceof Damageable);
        for (Entity entity2 : entities) {
            Damageable damageable = (Damageable)entity2;
            damageable.damage(damage);
        }
    }

    @Override
    public boolean isAsync() {
        return false;
    }
}

