/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.keyword.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.BlockContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import me.boboballoon.innovativeitems.functions.keyword.Keyword;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class ExplodeKeyword
extends Keyword {
    public ExplodeKeyword() {
        super("explode", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY, FunctionTargeter.BLOCK), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.FLOAT, "explosion power"), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.BOOLEAN, "should break blocks"));
    }

    @Override
    protected void calling(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        Location location = null;
        FunctionTargeter rawLocation = (FunctionTargeter)((Object)arguments.get(0));
        if (rawLocation == FunctionTargeter.PLAYER) {
            location = context.getPlayer().getLocation();
        }
        if (rawLocation == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            location = entityContext.getEntity().getLocation();
        }
        if (rawLocation == FunctionTargeter.BLOCK && context instanceof BlockContext) {
            BlockContext blockContext = (BlockContext)((Object)context);
            location = blockContext.getBlock().getLocation();
        }
        float power = ((Float)arguments.get(1)).floatValue();
        boolean breakBlocks = (Boolean)arguments.get(2);
        location.getWorld().createExplosion(location, power, false, breakBlocks);
    }

    @Override
    public boolean isAsync() {
        return false;
    }
}

