/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.context;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.BlockContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.ItemContext;
import me.boboballoon.innovativeitems.items.InnovativeCache;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlexibleContext
extends RuntimeContext
implements EntityContext,
BlockContext,
ItemContext {
    private final LivingEntity entity;
    private final Block block;
    private final CustomItem item;

    public FlexibleContext(@NotNull Player player, @NotNull Ability ability, @Nullable LivingEntity entity, @Nullable Block block, @Nullable CustomItem item) {
        super(player, ability);
        this.entity = entity;
        this.block = block;
        this.item = item;
    }

    public FlexibleContext(@NotNull Player player, @NotNull Ability ability, @NotNull RuntimeContext delegate) {
        this(player, ability, delegate instanceof EntityContext ? ((EntityContext)((Object)delegate)).getEntity() : null, delegate instanceof BlockContext ? ((BlockContext)((Object)delegate)).getBlock() : null, delegate instanceof ItemContext ? ((ItemContext)((Object)delegate)).getItem() : null);
    }

    public FlexibleContext(@NotNull Player player, @NotNull Ability ability) {
        this(player, ability, null, null, null);
    }

    @Override
    @NotNull
    public LivingEntity getEntity() {
        if (this.entity != null) {
            return this.entity;
        }
        Player player = this.getPlayer();
        Iterator entities = player.getNearbyEntities(5.0, 5.0, 5.0).stream().filter(e -> e instanceof LivingEntity).iterator();
        if (entities.hasNext()) {
            return (LivingEntity)entities.next();
        }
        return player;
    }

    @Override
    @NotNull
    public Block getBlock() {
        if (this.block != null) {
            return this.block;
        }
        return this.getPlayer().getLocation().getBlock();
    }

    @Override
    @NotNull
    public CustomItem getItem() {
        if (this.item != null) {
            return this.item;
        }
        InnovativeCache cache = InnovativeItems.getInstance().getItemCache();
        CustomItem item = this.getCustomItemFromInventory(cache);
        if (item != null) {
            return item;
        }
        ImmutableList<CustomItem> items = cache.getItems();
        if (items.size() > 0) {
            return (CustomItem)items.stream().findAny().get();
        }
        CustomItem dummyItem = new CustomItem("dummy-item", null, Material.DIRT, null, null, null, null, null, null, false, false, false, false, 0, false, null);
        cache.registerItem(dummyItem);
        LogUtil.logUnblocked(LogUtil.Level.INFO, "The player " + this.getPlayer().getName() + " (" + this.getPlayer().getUniqueId() + ") used the ability " + this.getAbility().getIdentifier() + ", which relied on a custom item targeter that had no fallback, so a new dummy fallback item was registered (will only exist in memory).");
        return dummyItem;
    }

    @Nullable
    private CustomItem getCustomItemFromInventory(InnovativeCache cache) {
        PlayerInventory inventory = this.getPlayer().getInventory();
        CustomItem mainHand = cache.fromItemStack(inventory.getItemInMainHand());
        if (mainHand != null) {
            return mainHand;
        }
        for (ItemStack item : inventory) {
            CustomItem customItem = cache.fromItemStack(item);
            if (customItem == null) continue;
            return customItem;
        }
        return null;
    }

    @NotNull
    public static FlexibleContext wrap(@NotNull RuntimeContext context) {
        return context instanceof FlexibleContext ? (FlexibleContext)context : new FlexibleContext(context.getPlayer(), context.getAbility(), context);
    }
}

