/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.condition.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedEnum;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import me.boboballoon.innovativeitems.util.RevisedEquipmentSlot;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class IsUsingItemCondition
extends Condition {
    public IsUsingItemCondition() {
        super("isusingitem", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY), new ExpectedEnum<Material>(Material.class, "material"), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.INTEGER, "item amount"), new ExpectedEnum<RevisedEquipmentSlot>(RevisedEquipmentSlot.class, "equipment slot"));
    }

    @Override
    protected Boolean call(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        Player target = null;
        FunctionTargeter targeter = (FunctionTargeter)((Object)arguments.get(0));
        if (targeter == FunctionTargeter.PLAYER) {
            target = context.getPlayer();
        }
        if (targeter == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            if (!(entityContext.getEntity() instanceof Player)) {
                return false;
            }
            target = (Player)entityContext.getEntity();
        }
        Material material = (Material)arguments.get(1);
        int amount = (Integer)arguments.get(2);
        RevisedEquipmentSlot slot = (RevisedEquipmentSlot)((Object)arguments.get(3));
        for (ItemStack item : slot.getFromPlayer(target)) {
            if (item == null || item.getType() != material || item.getAmount() < amount) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

