/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.condition.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class IsHeathPercentAtCondition
extends Condition {
    public IsHeathPercentAtCondition() {
        super("ishealthpercentat", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.DOUBLE, "percent amount"), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.CHAR, "operation", object -> {
            char value = ((Character)object).charValue();
            return value == '>' || value == '<' || value == '=';
        }));
    }

    @Override
    protected Boolean call(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        Player target = null;
        FunctionTargeter targeter = (FunctionTargeter)((Object)arguments.get(0));
        if (targeter == FunctionTargeter.PLAYER) {
            target = context.getPlayer();
        }
        if (targeter == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            target = entityContext.getEntity();
        }
        double amount = (Double)arguments.get(1) / 100.0;
        double activeAmount = target.getHealth() / target.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        char operation = ((Character)arguments.get(2)).charValue();
        if (operation == '>') {
            return activeAmount > amount;
        }
        if (operation == '<') {
            return activeAmount < amount;
        }
        if (operation == '=') {
            return activeAmount == amount;
        }
        return null;
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

