/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.condition.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class IsHeathAtCondition
extends Condition {
    public IsHeathAtCondition() {
        super("ishealthat", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.INTEGER, "health amount"), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.CHAR, "operation", object -> {
            char value = ((Character)object).charValue();
            return value == '>' || value == '<' || value == '=';
        }));
    }

    @Override
    protected Boolean call(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        Player target = null;
        FunctionTargeter targeter = (FunctionTargeter)((Object)arguments.get(0));
        if (targeter == FunctionTargeter.PLAYER) {
            target = context.getPlayer();
        }
        if (targeter == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            target = entityContext.getEntity();
        }
        int amount = (Integer)arguments.get(1);
        int activeAmount = (int)target.getHealth();
        char operation = ((Character)arguments.get(2)).charValue();
        if (operation == '>') {
            return activeAmount > amount;
        }
        if (operation == '<') {
            return activeAmount < amount;
        }
        if (operation == '=') {
            return activeAmount == amount;
        }
        return null;
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

