/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.condition.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedEnum;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class IsGamemodeCondition
extends Condition {
    public IsGamemodeCondition() {
        super("isgamemode", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY), new ExpectedEnum<GameMode>(GameMode.class, "gamemode"));
    }

    @Override
    protected Boolean call(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        Player target = null;
        FunctionTargeter targeter = (FunctionTargeter)((Object)arguments.get(0));
        if (targeter == FunctionTargeter.PLAYER) {
            target = context.getPlayer();
        }
        if (targeter == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            if (!(entityContext.getEntity() instanceof Player)) {
                return false;
            }
            target = (Player)entityContext.getEntity();
        }
        GameMode gameMode = (GameMode)arguments.get(1);
        return target.getGameMode() == gameMode;
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

