/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.condition.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import me.boboballoon.innovativeitems.util.ExperienceUtil;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class IsExperienceAtCondition
extends Condition {
    public IsExperienceAtCondition() {
        super("isexperienceat", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.INTEGER, "experience amount"), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.CHAR, "operation", object -> {
            char value = ((Character)object).charValue();
            return value == '>' || value == '<' || value == '=';
        }));
    }

    @Override
    protected Boolean call(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        Player target = null;
        FunctionTargeter targeter = (FunctionTargeter)((Object)arguments.get(0));
        if (targeter == FunctionTargeter.PLAYER) {
            target = context.getPlayer();
        }
        if (targeter == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            if (!(entityContext.getEntity() instanceof Player)) {
                return false;
            }
            target = (Player)entityContext.getEntity();
        }
        int total = ExperienceUtil.getExp(target);
        int experience = (Integer)arguments.get(1);
        char operator = ((Character)arguments.get(2)).charValue();
        return operator == '>' ? total > experience : (operator == '<' ? total < experience : (operator == '=' ? total == experience : false));
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

