/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.condition.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedEnum;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.BlockContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

public class IsBlockCondition
extends Condition {
    public IsBlockCondition() {
        super("isblock", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY, FunctionTargeter.BLOCK), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.INTEGER, "x offset"), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.INTEGER, "y offset"), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.INTEGER, "z offset"), new ExpectedEnum<Material>(Material.class, "material type"));
    }

    @Override
    protected Boolean call(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        FunctionTargeter targeter = (FunctionTargeter)((Object)arguments.get(0));
        Location location = null;
        if (targeter == FunctionTargeter.PLAYER) {
            location = context.getPlayer().getLocation();
        }
        if (targeter == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            location = entityContext.getEntity().getLocation();
        }
        if (targeter == FunctionTargeter.BLOCK && context instanceof BlockContext) {
            BlockContext blockContext = (BlockContext)((Object)context);
            location = blockContext.getBlock().getLocation();
        }
        int xOffset = (Integer)arguments.get(1);
        int yOffset = (Integer)arguments.get(2);
        int zOffset = (Integer)arguments.get(3);
        Block block = location.clone().add((double)xOffset, (double)yOffset, (double)zOffset).getBlock();
        Material material = (Material)arguments.get(4);
        return block.getType() == material;
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

