/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.condition.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.FunctionTargeter;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedManual;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedTargeters;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.context.interfaces.EntityContext;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class HasPotionEffectCondition
extends Condition {
    public HasPotionEffectCondition() {
        super("haspotioneffect", new ExpectedTargeters(FunctionTargeter.PLAYER, FunctionTargeter.ENTITY), new ExpectedManual((rawValue, context) -> PotionEffectType.getByName((String)rawValue), "potion effect"), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.INTEGER, "level requirement", object -> {
            int requirement = (Integer)object;
            return requirement >= 0;
        }), new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.CHAR, "operation", object -> {
            char operation = ((Character)object).charValue();
            return operation == '>' || operation == '<' || operation == '=';
        }));
    }

    @Override
    protected Boolean call(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        PotionEffectType potionEffectType;
        PotionEffect effect;
        Player target = null;
        FunctionTargeter targeter = (FunctionTargeter)((Object)arguments.get(0));
        if (targeter == FunctionTargeter.PLAYER) {
            target = context.getPlayer();
        }
        if (targeter == FunctionTargeter.ENTITY && context instanceof EntityContext) {
            EntityContext entityContext = (EntityContext)((Object)context);
            target = entityContext.getEntity();
        }
        if ((effect = target.getPotionEffect(potionEffectType = (PotionEffectType)arguments.get(1))) == null) {
            return false;
        }
        int requirement = (Integer)arguments.get(2);
        char operation = ((Character)arguments.get(3)).charValue();
        int level = effect.getAmplifier() + 1;
        return operation == '=' && level == requirement || operation == '>' && level > requirement || operation == '<' && level < requirement;
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

