/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.condition.builtin;

import com.google.common.collect.ImmutableList;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedPrimitive;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import org.jetbrains.annotations.NotNull;

public class ChanceCondition
extends Condition {
    public ChanceCondition() {
        super("chance", new ExpectedPrimitive(ExpectedPrimitive.PrimitiveType.DOUBLE, "percent chance", raw -> {
            double value = (Double)raw;
            return value > 0.0 && value < 100.0;
        }));
    }

    @Override
    protected Boolean call(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) {
        double percent = (Double)arguments.get(0);
        return Math.random() <= percent / 100.0;
    }

    @Override
    public boolean isAsync() {
        return true;
    }
}

