/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.arguments;

import java.util.function.Consumer;
import java.util.function.Predicate;
import me.boboballoon.innovativeitems.functions.FunctionContext;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedArguments;
import me.boboballoon.innovativeitems.util.InitializationUtil;
import me.boboballoon.innovativeitems.util.LogUtil;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedPrimitive
implements ExpectedArguments {
    private final PrimitiveType primitive;
    private final Consumer<FunctionContext> onError;
    private final Predicate<Object> condition;

    public ExpectedPrimitive(@NotNull PrimitiveType primitive, @Nullable Consumer<FunctionContext> onError, @Nullable Predicate<Object> condition) {
        this.primitive = primitive;
        this.onError = onError != null ? onError : ExpectedArguments.DEFAULT_ERROR;
        this.condition = condition != null ? condition : value -> true;
    }

    public ExpectedPrimitive(@NotNull PrimitiveType primitive, @Nullable Consumer<FunctionContext> onError) {
        this(primitive, onError, null);
    }

    public ExpectedPrimitive(@NotNull PrimitiveType primitive, @Nullable Predicate<Object> condition) {
        this(primitive, (Consumer<FunctionContext>)null, condition);
    }

    public ExpectedPrimitive(@NotNull PrimitiveType primitive, @NotNull String fieldName, @Nullable Predicate<Object> condition) {
        this(primitive, (FunctionContext context) -> LogUtil.logFunctionError(context, fieldName), condition);
    }

    public ExpectedPrimitive(@NotNull PrimitiveType primitive, @NotNull String fieldName) {
        this(primitive, fieldName, null);
    }

    public ExpectedPrimitive(@NotNull PrimitiveType primitive) {
        this(primitive, (Consumer<FunctionContext>)null, null);
    }

    public PrimitiveType getPrimitive() {
        return this.primitive;
    }

    @Override
    @NotNull
    public Consumer<FunctionContext> getOnError() {
        return this.onError;
    }

    @Nullable
    public Predicate<Object> getCondition() {
        return this.condition;
    }

    @Override
    @Nullable
    public Object getValue(@NotNull String rawValue, @NotNull FunctionContext context) {
        Object value = this.primitive == PrimitiveType.STRING ? TextUtil.format(rawValue) : (this.primitive == PrimitiveType.CHAR ? (Comparable<Character>)Character.valueOf(InitializationUtil.initChar(rawValue)) : (Comparable<Character>)(this.primitive == PrimitiveType.BOOLEAN ? Boolean.valueOf(InitializationUtil.initBoolean(rawValue)) : InitializationUtil.initNumber(rawValue, this.primitive.getRepresentingClass())));
        return this.condition.test(value) ? value : null;
    }

    public static enum PrimitiveType {
        BYTE(Byte.class),
        SHORT(Short.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        BOOLEAN(Boolean.TYPE),
        CHAR(Character.TYPE),
        STRING(String.class);

        private final Class<?> clazz;

        private PrimitiveType(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getRepresentingClass() {
            return this.clazz;
        }
    }
}

