/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions.arguments;

import java.util.function.Consumer;
import me.boboballoon.innovativeitems.functions.FunctionContext;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedArguments;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedManual
implements ExpectedArguments {
    private final ExpectedFunction manual;
    private final Consumer<FunctionContext> onError;

    public ExpectedManual(@NotNull ExpectedFunction manual, @NotNull Consumer<FunctionContext> onError) {
        this.manual = manual;
        this.onError = onError;
    }

    public ExpectedManual(@NotNull ExpectedFunction manual, @NotNull String fieldName) {
        this(manual, (FunctionContext context) -> LogUtil.logFunctionError(context, fieldName));
    }

    public ExpectedManual(@NotNull ExpectedFunction manual) {
        this(manual, ExpectedArguments.DEFAULT_ERROR);
    }

    @Override
    @NotNull
    public Consumer<FunctionContext> getOnError() {
        return this.onError;
    }

    @Override
    public Object getValue(@NotNull String rawValue, @NotNull FunctionContext context) {
        try {
            return this.manual.getValue(rawValue, context);
        }
        catch (Exception e) {
            return null;
        }
    }

    @FunctionalInterface
    public static interface ExpectedFunction {
        @Nullable
        public Object getValue(@NotNull String var1, @NotNull FunctionContext var2) throws Exception;
    }
}

