/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions;

import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedArguments;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InnovativeFunction<T> {
    private final String identifier;
    private final ImmutableList<ExpectedArguments> arguments;

    public InnovativeFunction(@NotNull String identifier, ExpectedArguments ... arguments) {
        this.identifier = identifier;
        this.arguments = ImmutableList.copyOf((Object[])arguments);
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public final ImmutableList<ExpectedArguments> getArguments() {
        return this.arguments;
    }

    protected abstract T call(@NotNull ImmutableList<Object> var1, @NotNull RuntimeContext var2);

    public abstract boolean isAsync();

    @Nullable
    public final T execute(@NotNull ImmutableList<Object> arguments, @NotNull RuntimeContext context) throws ExecutionException {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("The function execute method cannot be called from the main thread!");
        }
        if (this.isAsync()) {
            return this.call(arguments, context);
        }
        Future future = Bukkit.getScheduler().callSyncMethod((Plugin)InnovativeItems.getInstance(), () -> this.call(arguments, context));
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ExecutionException("The value of " + this.identifier + " was unable to be initialized in time.", e);
        }
    }
}

