/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.Map;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.functions.InnovativeFunction;
import me.boboballoon.innovativeitems.functions.arguments.ExpectedVarArg;
import me.boboballoon.innovativeitems.functions.condition.Condition;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.functions.keyword.Keyword;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.ability.trigger.AbilityTrigger;
import me.boboballoon.innovativeitems.items.ability.trigger.ManuallyRegister;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionManager {
    private final Map<String, Keyword> keywords = new LinkedHashMap<String, Keyword>();
    private final Map<String, Condition> conditions = new LinkedHashMap<String, Condition>();
    private final Map<String, AbilityTrigger<?, ?>> triggers = new LinkedHashMap();

    public FunctionManager() {
        LogUtil.logUnblocked(LogUtil.Level.INFO, "Function manager initialized!");
    }

    public void registerKeyword(@NotNull Keyword keyword) {
        String identifier = keyword.getIdentifier();
        if (this.isInvalidIdentifier(identifier)) {
            LogUtil.logUnblocked(LogUtil.Level.DEV, "Keyword with the identifier of " + identifier + " is not valid! Skipping...");
            return;
        }
        if (!this.hasValidArguments(keyword)) {
            LogUtil.logUnblocked(LogUtil.Level.DEV, "Keyword with the identifier of " + identifier + " is not valid due to incorrect usage of var-args! Skipping...");
            return;
        }
        this.keywords.put(identifier, keyword);
    }

    public void registerKeyword(@NotNull String depend, @NotNull Keyword keyword) {
        if (Bukkit.getPluginManager().getPlugin(depend) == null) {
            return;
        }
        this.registerKeyword(keyword);
    }

    public void registerCondition(@NotNull Condition condition) {
        String identifier = condition.getIdentifier();
        if (this.isInvalidIdentifier(identifier)) {
            LogUtil.logUnblocked(LogUtil.Level.DEV, "Condition with the identifier of " + identifier + " is not valid! Skipping...");
            return;
        }
        if (!this.hasValidArguments(condition)) {
            LogUtil.logUnblocked(LogUtil.Level.DEV, "Condition with the identifier of " + identifier + " is not valid due to incorrect usage of var-args! Skipping...");
            return;
        }
        this.conditions.put(identifier, condition);
    }

    public void registerCondition(@NotNull String depend, @NotNull Condition condition) {
        if (Bukkit.getPluginManager().getPlugin(depend) == null) {
            return;
        }
        this.registerCondition(condition);
    }

    public void registerKeywords(Keyword ... keywords) {
        for (Keyword keyword : keywords) {
            this.registerKeyword(keyword);
        }
    }

    public void registerKeywords(@NotNull String depend, Keyword ... keywords) {
        if (Bukkit.getPluginManager().getPlugin(depend) == null) {
            return;
        }
        this.registerKeywords(keywords);
    }

    public void registerConditions(Condition ... conditions) {
        for (Condition condition : conditions) {
            this.registerCondition(condition);
        }
    }

    public void registerConditions(@NotNull String depend, Condition ... conditions) {
        if (Bukkit.getPluginManager().getPlugin(depend) == null) {
            return;
        }
        this.registerConditions(conditions);
    }

    public void registerTrigger(@NotNull AbilityTrigger<?, ?> trigger) {
        if (this.contains(trigger.getIdentifier()) || !trigger.getIdentifier().matches("[\\w-]+")) {
            return;
        }
        this.triggers.put(trigger.getIdentifier(), trigger);
        if (InnovativeItems.getInstance().isEnabled()) {
            FunctionManager.registerTriggerEvent(trigger);
        }
    }

    public void registerTrigger(@NotNull String depend, @NotNull AbilityTrigger<?, ?> trigger) {
        if (Bukkit.getPluginManager().getPlugin(depend) == null) {
            return;
        }
        this.registerTrigger(trigger);
    }

    public void registerTriggers(AbilityTrigger<?, ?> ... triggers) {
        for (AbilityTrigger<?, ?> trigger : triggers) {
            this.registerTrigger(trigger);
        }
    }

    public void registerTrigger(@NotNull String depend, AbilityTrigger<?, ?> ... triggers) {
        if (Bukkit.getPluginManager().getPlugin(depend) == null) {
            return;
        }
        this.registerTriggers(triggers);
    }

    @Nullable
    public Keyword getKeyword(@NotNull String identifier) {
        return this.keywords.get(identifier);
    }

    @NotNull
    public ImmutableList<Keyword> getKeywords() {
        return ImmutableList.copyOf(this.keywords.values());
    }

    @Nullable
    public Condition getCondition(@NotNull String identifier) {
        return this.conditions.get(identifier);
    }

    @NotNull
    public ImmutableList<Condition> getConditions() {
        return ImmutableList.copyOf(this.conditions.values());
    }

    @Nullable
    public AbilityTrigger<?, ?> getAbilityTrigger(@NotNull String identifier) {
        for (AbilityTrigger<?, ?> trigger : this.triggers.values()) {
            if (trigger.getIdentifier().equals(trigger.getRegex()) || !identifier.matches(trigger.getRegex())) continue;
            return trigger;
        }
        return this.triggers.get(identifier);
    }

    @NotNull
    public ImmutableList<AbilityTrigger<?, ?>> getAbilityTriggers() {
        return ImmutableList.copyOf(this.triggers.values());
    }

    public boolean contains(@NotNull String identifier) {
        return this.keywords.containsKey(identifier) || this.conditions.containsKey(identifier) || this.triggers.containsKey(identifier);
    }

    public boolean isInvalidIdentifier(@NotNull String identifier) {
        return this.contains(identifier) || !identifier.matches("\\w+");
    }

    public void registerCachedTriggers() {
        for (AbilityTrigger<?, ?> trigger : this.triggers.values()) {
            FunctionManager.registerTriggerEvent(trigger);
        }
    }

    private boolean hasValidArguments(@NotNull InnovativeFunction<?> function) {
        for (int i = 0; i < function.getArguments().size(); ++i) {
            if (!(function.getArguments().get(i) instanceof ExpectedVarArg) || i == function.getArguments().size() - 1) continue;
            return false;
        }
        return true;
    }

    private static <T extends Event> void registerTriggerEvent(@NotNull AbilityTrigger<T, ?> trigger) {
        if (trigger.getClass().isAnnotationPresent(ManuallyRegister.class)) {
            return;
        }
        Bukkit.getPluginManager().registerEvent(trigger.getEventClass(), trigger, EventPriority.HIGHEST, (listener, instance) -> {
            if (!trigger.getEventClass().isInstance(instance)) {
                return;
            }
            Event event = instance;
            if (!trigger.getPredicate().test(event)) {
                LogUtil.log(LogUtil.Level.NOISE, "The event " + event.getEventName() + " failed the trigger predicate on the " + trigger.getIdentifier() + " ability trigger!");
                return;
            }
            Player player = trigger.fromEvent(event);
            for (CustomItem item : trigger.getIterator().getItems(event, player)) {
                Object context;
                Ability ability;
                if (item == null || (ability = item.getAbility()) == null || ability.getTrigger() != trigger || (context = trigger.trigger(event, item, ability)) == null) continue;
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)InnovativeItems.getInstance(), () -> ability.execute((RuntimeContext)context));
            }
        }, (Plugin)InnovativeItems.getInstance());
    }
}

