/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.functions;

import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.functions.InnovativeFunction;
import me.boboballoon.innovativeitems.functions.context.RuntimeContext;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActiveFunction<T> {
    private final InnovativeFunction<T> base;
    private final ImmutableList<Object> arguments;

    public ActiveFunction(@NotNull InnovativeFunction<T> base, @NotNull ImmutableList<Object> arguments) {
        this.base = base;
        this.arguments = arguments;
    }

    public InnovativeFunction<T> getBase() {
        return this.base;
    }

    public final ImmutableList<Object> getArguments() {
        return this.arguments;
    }

    @Nullable
    public final T execute(@NotNull RuntimeContext context) {
        try {
            return this.base.execute(this.arguments, context);
        }
        catch (ExecutionException e) {
            LogUtil.log(LogUtil.Level.SEVERE, "There was an error trying to execute the " + this.base.getIdentifier() + " function on the " + context.getAbilityName() + " ability!");
            if (InnovativeItems.getInstance().getConfigManager().getDebugLevel() >= LogUtil.Level.DEV.getDebugLevel()) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

