/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.config.AbilityParser;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.items.item.RecipeType;
import me.boboballoon.innovativeitems.util.LogUtil;
import me.boboballoon.innovativeitems.util.RevisedEquipmentSlot;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemParser {
    private ItemParser() {
    }

    @Nullable
    public static CustomItem parseItem(@NotNull ConfigurationSection section, @NotNull String name) {
        return ItemParser.parseItem(section, name, true);
    }

    @Nullable
    public static CustomItem parseItem(@NotNull ConfigurationSection section, @NotNull String name, boolean parseRecipe) {
        Material material;
        if (!section.isString("material")) {
            LogUtil.log(LogUtil.Level.WARNING, "Could not find material field while parsing the item by the name of " + name + "!");
            return null;
        }
        try {
            material = Material.valueOf((String)section.getString("material").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LogUtil.log(LogUtil.Level.WARNING, "Unknown material provided while parsing the item by the name of " + name + " during item initialization and parsing stage!");
            return null;
        }
        Ability ability = section.isString("ability") || section.isConfigurationSection("ability") ? ItemParser.getAbility(section, name) : null;
        String displayName = section.isString("display-name") ? TextUtil.format(section.getString("display-name")) : null;
        List<String> lore = section.isList("lore") ? ItemParser.getLore(section) : null;
        Map<Enchantment, Integer> enchantments = section.isConfigurationSection("enchantments") ? ItemParser.getEnchantments(section, name) : null;
        List<ItemFlag> flags = section.isList("flags") ? ItemParser.getItemFlags(section, name) : null;
        Multimap<Attribute, AttributeModifier> attributes = section.isConfigurationSection("attributes") ? ItemParser.getAttributes(section, name) : null;
        Integer customModelData = section.isInt("custom-model-data") ? Integer.valueOf(section.getInt("custom-model-data")) : null;
        boolean unbreakable = section.getBoolean("unbreakable");
        boolean placeable = section.getBoolean("placeable");
        boolean soulbound = section.getBoolean("soulbound");
        boolean wearable = section.isBoolean("wearable") ? section.getBoolean("wearable") : true;
        int maxDurability = section.isInt("max-durability") ? section.getInt("max-durability") : material.getMaxDurability();
        boolean updateItem = section.isBoolean("update-item") ? section.getBoolean("update-item") : true;
        ItemStack underlying = ItemParser.createUnderlyingItemStack(section, name, material, displayName, lore, enchantments, flags, attributes, customModelData, unbreakable, maxDurability);
        ImmutableList<Recipe> recipes = parseRecipe && section.isConfigurationSection("recipes") ? ItemParser.getRecipe(section, name, underlying) : null;
        return new CustomItem(name, ability, underlying, placeable, soulbound, wearable, maxDurability, updateItem, recipes);
    }

    private static ItemStack createUnderlyingItemStack(ConfigurationSection section, @NotNull String identifier, @NotNull Material material, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, boolean unbreakable, int durability) {
        if (section.isConfigurationSection("skull") && material == Material.PLAYER_HEAD) {
            ConfigurationSection skullSection = section.getConfigurationSection("skull");
            return SkullItem.generateItem(identifier, itemName, lore, enchantments, flags, attributes, customModelData, ItemParser.getSkullName(skullSection), ItemParser.getSkullBase64(skullSection));
        }
        if (section.isConfigurationSection("leather-armor") && LeatherArmorItem.isLeatherArmor(material)) {
            ConfigurationSection leatherArmorSection = section.getConfigurationSection("leather-armor");
            DyeColor color = ItemParser.getColor(leatherArmorSection, itemName);
            return LeatherArmorItem.generateItem(identifier, material, itemName, lore, enchantments, flags, attributes, customModelData, unbreakable, durability, ItemParser.getRGB(leatherArmorSection, itemName), color != null ? color.getColor() : null);
        }
        if (section.isConfigurationSection("potion") && PotionItem.isPotion(material)) {
            ConfigurationSection potionSection = section.getConfigurationSection("potion");
            DyeColor color = ItemParser.getColor(potionSection, itemName);
            return PotionItem.generateItem(identifier, material, itemName, lore, enchantments, flags, attributes, customModelData, ItemParser.getRGB(potionSection, itemName), color != null ? color.getColor() : null, ItemParser.getPotionEffects(potionSection, itemName));
        }
        if (section.isConfigurationSection("banner") && BannerItem.isBanner(material)) {
            ConfigurationSection bannerSection = section.getConfigurationSection("banner");
            return BannerItem.generateItem(identifier, material, itemName, lore, enchantments, flags, attributes, customModelData, durability, ItemParser.getBannerPatterns(bannerSection, itemName));
        }
        if (section.isConfigurationSection("firework") && material == Material.FIREWORK_ROCKET) {
            ConfigurationSection fireworkSection = section.getConfigurationSection("firework");
            return FireworkItem.generateItem(identifier, itemName, lore, enchantments, flags, attributes, customModelData, ItemParser.getFireworkEffects(fireworkSection, itemName), ItemParser.getFireworkPower(fireworkSection, itemName));
        }
        if (section.isConfigurationSection("shield") && material == Material.SHIELD) {
            ConfigurationSection shieldSection = section.getConfigurationSection("shield");
            return ShieldItem.generateItem(identifier, itemName, lore, enchantments, flags, attributes, customModelData, durability, ItemParser.getBannerPatterns(shieldSection, itemName), ItemParser.getColor(shieldSection, itemName));
        }
        return CustomItem.generateItem(identifier, material, itemName, lore, enchantments, flags, attributes, customModelData, unbreakable, durability);
    }

    private static Ability getAbility(ConfigurationSection section, String itemName) {
        boolean isConfigurationSection;
        Ability ability = null;
        String abilityName = null;
        if (section.isString("ability")) {
            String rawAbility;
            abilityName = rawAbility = section.getString("ability");
            ability = InnovativeItems.getInstance().getItemCache().getAbility(rawAbility);
        }
        if ((isConfigurationSection = section.isConfigurationSection("ability")) && InnovativeItems.isPluginPremium()) {
            ConfigurationSection abilitySection = section.getConfigurationSection("ability");
            abilityName = itemName + "-anonymous-ability";
            ability = AbilityParser.parseAbility(abilitySection, abilityName);
        } else if (isConfigurationSection) {
            LogUtil.logUnblocked(LogUtil.Level.WARNING, "An anonymous ability was used for the " + itemName + " item but are not supported in the free version of the plugin!");
            return null;
        }
        if (ability == null) {
            LogUtil.log(LogUtil.Level.WARNING, "Could not find or parse ability with the name " + abilityName + " while parsing the item by the name of " + itemName + " during item initialization and parsing stage!");
        }
        return ability;
    }

    private static List<String> getLore(ConfigurationSection section) {
        List lore = section.getStringList("lore");
        for (int i = 0; i < lore.size(); ++i) {
            String element = TextUtil.format((String)lore.get(i));
            lore.set(i, element);
        }
        return lore;
    }

    private static Map<Enchantment, Integer> getEnchantments(ConfigurationSection section, String itemName) {
        ConfigurationSection enchantmentSection = section.getConfigurationSection("enchantments");
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (String enchantmentName : enchantmentSection.getKeys(false)) {
            Enchantment enchantment;
            int level = enchantmentSection.getInt(enchantmentName);
            Enchantment enchantment2 = enchantment = Enchantment.getByName((String)enchantmentName.toUpperCase()) != null ? Enchantment.getByName((String)enchantmentName.toUpperCase()) : Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantmentName.toLowerCase()));
            if (enchantment == null) {
                LogUtil.log(LogUtil.Level.WARNING, "Could not find enchantment with the name " + enchantmentName + " while parsing the item by the name of " + itemName + " during item initialization and parsing stage!");
                continue;
            }
            enchantments.put(enchantment, level);
        }
        return enchantments;
    }

    private static List<ItemFlag> getItemFlags(ConfigurationSection section, String itemName) {
        ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>();
        for (String flag : section.getStringList("flags")) {
            ItemFlag itemFlag;
            try {
                itemFlag = ItemFlag.valueOf((String)flag.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LogUtil.log(LogUtil.Level.WARNING, "Unknown itemflag provided while parsing the item by the name of " + itemName + " during item initialization and parsing stage!");
                continue;
            }
            flags.add(itemFlag);
        }
        return flags;
    }

    private static Multimap<Attribute, AttributeModifier> getAttributes(ConfigurationSection section, String itemName) {
        ArrayListMultimap attributes = ArrayListMultimap.create();
        ConfigurationSection attributeSection = section.getConfigurationSection("attributes");
        for (String slotName : attributeSection.getKeys(false)) {
            RevisedEquipmentSlot slot;
            try {
                slot = RevisedEquipmentSlot.valueOf(slotName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LogUtil.log(LogUtil.Level.WARNING, "The unknown equipment slot " + slotName.toUpperCase() + " was provided in the attribute section while parsing the item by the name of " + itemName + " during item initialization and parsing stage!");
                continue;
            }
            ConfigurationSection modifierSection = attributeSection.getConfigurationSection(slotName);
            int counter = -128;
            for (String attributeName : modifierSection.getKeys(false)) {
                Attribute attribute;
                try {
                    attribute = Attribute.valueOf((String)attributeName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    LogUtil.log(LogUtil.Level.WARNING, "Unknown attribute provided while parsing the item by the name of " + itemName + " during item initialization and parsing stage!");
                    continue;
                }
                byte[] array = Arrays.copyOf(itemName.getBytes(), itemName.getBytes().length + 1);
                array[itemName.getBytes().length] = counter;
                attributes.put((Object)attribute, (Object)new AttributeModifier(UUID.nameUUIDFromBytes(array), "test-value", modifierSection.getDouble(attributeName), AttributeModifier.Operation.ADD_NUMBER, slot.getSlot()));
                counter = (byte)(counter + 1);
            }
        }
        return attributes;
    }

    private static String getSkullName(ConfigurationSection section) {
        if (!section.isString("player-name")) {
            return null;
        }
        return section.getString("player-name");
    }

    private static String getSkullBase64(ConfigurationSection section) {
        if (!section.isString("base64")) {
            return null;
        }
        return section.getString("base64");
    }

    private static Color getRGB(ConfigurationSection section, String itemName) {
        if (!section.isString("rgb")) {
            return null;
        }
        String[] rgbRaw = section.getString("rgb").split(",");
        if (rgbRaw.length != 3) {
            return null;
        }
        int[] rgb = new int[3];
        try {
            rgb[0] = Integer.parseInt(rgbRaw[0]);
            rgb[1] = Integer.parseInt(rgbRaw[1]);
            rgb[2] = Integer.parseInt(rgbRaw[2]);
        }
        catch (NumberFormatException e) {
            LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing the rgb values of " + itemName + "!");
            return null;
        }
        return Color.fromRGB((int)rgb[0], (int)rgb[1], (int)rgb[2]);
    }

    private static DyeColor getColor(ConfigurationSection section, String itemName) {
        DyeColor color;
        if (!section.isString("color")) {
            return null;
        }
        String rawColor = section.getString("color").toUpperCase();
        try {
            color = DyeColor.valueOf((String)rawColor);
        }
        catch (IllegalArgumentException ignore) {
            LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing the color of " + itemName + "! Please make sure that the value you entered was a real color!");
            return null;
        }
        return color;
    }

    private static List<PotionEffect> getPotionEffects(ConfigurationSection section, String itemName) {
        List rawEffects = section.getStringList("effects");
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (String rawEffect : rawEffects) {
            int level;
            int duration;
            String[] components = rawEffect.split(" ");
            if (components.length != 3) {
                LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing one of the effect strings of " + itemName + "! Please make sure that the value you entered followed the potion effect syntax!");
                continue;
            }
            PotionEffectType type = PotionEffectType.getByName((String)components[0]);
            if (type == null) {
                LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing one of the effect strings of " + itemName + "! Please make sure that the potion name you entered was correct!");
                continue;
            }
            try {
                duration = Integer.parseInt(components[1]);
            }
            catch (NumberFormatException e) {
                LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing one of the effect strings of " + itemName + "! Please make sure that the duration you entered was an integer!");
                continue;
            }
            try {
                level = Integer.parseInt(components[2]);
            }
            catch (NumberFormatException e) {
                LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing one of the effect strings of " + itemName + "! Please make sure that the level you entered was an integer!");
                continue;
            }
            effects.add(new PotionEffect(type, duration, level));
        }
        return effects;
    }

    private static List<Pattern> getBannerPatterns(ConfigurationSection section, String itemName) {
        List rawPatterns = section.getStringList("patterns");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String rawPattern : rawPatterns) {
            DyeColor color;
            PatternType type;
            String[] components = rawPattern.split(" ");
            if (components.length != 2) {
                LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing one of the pattern strings of " + itemName + "! Please make sure that the value you entered followed the banner pattern syntax!");
                continue;
            }
            try {
                type = PatternType.valueOf((String)components[0]);
            }
            catch (IllegalArgumentException e) {
                LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing one of the pattern strings of " + itemName + "! Please make sure that the pattern type name you entered was correct!");
                continue;
            }
            try {
                color = DyeColor.valueOf((String)components[1]);
            }
            catch (IllegalArgumentException e) {
                LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing one of the pattern strings of " + itemName + "! Please make sure that the dye color name you entered was correct!");
                continue;
            }
            patterns.add(new Pattern(color, type));
        }
        return patterns;
    }

    private static List<FireworkEffect> getFireworkEffects(ConfigurationSection section, String itemName) {
        if (!section.isConfigurationSection("effects")) {
            return null;
        }
        ConfigurationSection effectsSection = section.getConfigurationSection("effects");
        ArrayList<FireworkEffect> effects = new ArrayList<FireworkEffect>();
        for (String key : effectsSection.getKeys(false)) {
            ConfigurationSection effectSection;
            FireworkEffect effect;
            if (!effectsSection.isConfigurationSection(key) || (effect = ItemParser.getFireworkEffect(effectSection = effectsSection.getConfigurationSection(key), itemName)) == null) continue;
            effects.add(effect);
        }
        return effects;
    }

    private static FireworkEffect getFireworkEffect(ConfigurationSection section, String itemName) {
        FireworkEffect.Type type;
        boolean flicker = section.isBoolean("flicker") ? section.getBoolean("flicker") : false;
        boolean trail = section.isBoolean("trail") ? section.getBoolean("trail") : false;
        if (section.isString("type")) {
            try {
                type = FireworkEffect.Type.valueOf((String)section.getString("type"));
            }
            catch (IllegalArgumentException e) {
                LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing the firework type of " + itemName + "! Please make sure that the firework type name you entered was correct!");
                return null;
            }
        } else {
            type = FireworkEffect.Type.BALL;
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        if (section.isList("colors")) {
            List rawColors = section.getStringList("colors");
            for (String rawColor : rawColors) {
                try {
                    Color color = DyeColor.valueOf((String)rawColor).getColor();
                    colors.add(color);
                }
                catch (IllegalArgumentException ignore) {
                    LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing the color of " + itemName + "! Please make sure that the value you entered was a real color!");
                    return null;
                }
            }
        }
        ArrayList<Color> fadeColors = new ArrayList<Color>();
        if (section.isList("fade-colors")) {
            List rawColors = section.getStringList("fade-colors");
            for (String rawColor : rawColors) {
                try {
                    Color color = DyeColor.valueOf((String)rawColor).getColor();
                    fadeColors.add(color);
                }
                catch (IllegalArgumentException ignore) {
                    LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing the fade color of " + itemName + "! Please make sure that the value you entered was a real color!");
                    return null;
                }
            }
        }
        return FireworkEffect.builder().flicker(flicker).trail(trail).with(type).withColor(colors).withFade(fadeColors).build();
    }

    private static Integer getFireworkPower(ConfigurationSection section, String itemName) {
        if (!section.isInt("flight-time")) {
            return null;
        }
        float flightTime = section.getInt("flight-time");
        int power = Math.round(flightTime / 20.0f);
        if (power > 128 || power < 0) {
            LogUtil.log(LogUtil.Level.WARNING, "There was an error parsing the firework flight time of " + itemName + "! Please make sure that the flight time is less than or equal to 1280 and great than or equal to 0!");
            return null;
        }
        return power;
    }

    @Nullable
    private static ImmutableList<Recipe> getRecipe(@NotNull ConfigurationSection section, @NotNull String itemName, @NotNull ItemStack underlying) {
        if (!InnovativeItems.isPluginPremium()) {
            LogUtil.logUnblocked(LogUtil.Level.WARNING, "You cannot create a custom crafting recipe using the free version of the plugin! Skipping the recipe of the item identified as: " + itemName);
            return null;
        }
        ConfigurationSection recipesSection = section.getConfigurationSection("recipes");
        ArrayList recipes = new ArrayList();
        int counter = 0;
        for (String recipeName : recipesSection.getKeys(false)) {
            CookingRecipe<?> recipe;
            RecipeType type;
            if (!recipesSection.isConfigurationSection(recipeName)) continue;
            ConfigurationSection recipeSection = recipesSection.getConfigurationSection(recipeName);
            if (!recipeSection.isString("type")) {
                LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": Every recipe must contain the type field to specific the type of crafting recipe! Refer to the documentation for valid options...");
                continue;
            }
            try {
                type = RecipeType.valueOf(recipeSection.getString("type").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": You have entered an invalid type of crafting recipe! Refer to the documentation for valid options...");
                continue;
            }
            if (type == RecipeType.SHAPED) {
                recipe = ItemParser.parseShapedRecipe(recipeSection, itemName, recipeName, underlying, counter);
            } else if (type == RecipeType.FURNACE || type == RecipeType.BLAST_FURNACE || type == RecipeType.SMOKER || type == RecipeType.CAMPFIRE) {
                recipe = ItemParser.parseCookingRecipe(recipeSection, itemName, recipeName, underlying, type, counter);
            } else {
                LogUtil.logUnblocked(LogUtil.Level.DEV, "Warning on recipe " + recipeName + " on item " + itemName + ": A valid recipe type without a proper implementation has been detected... Please report this to the developer of the plugin immediately!");
                continue;
            }
            if (recipe == null) continue;
            recipes.add(recipe);
            ++counter;
        }
        return !recipes.isEmpty() ? ImmutableList.copyOf(recipes) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static ShapedRecipe parseShapedRecipe(@NotNull ConfigurationSection recipeSection, @NotNull String itemName, @NotNull String recipeName, @NotNull ItemStack underlying, int count) {
        if (!recipeSection.isList("keys")) {
            LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": A list of keys is required when making a custom crafting recipe! Please review the documentation for the correct syntax and layout...");
            return null;
        }
        List keys = recipeSection.getStringList("keys");
        if (!keys.stream().allMatch(text -> text.matches("~?\\w:.+"))) {
            LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": The proper syntax is a unique character followed by a colon followed by a material or custom item is required! Please review the documentation for the correct syntax...");
            return null;
        }
        HashMap<Character, RecipeChoice.ExactChoice> keyMap = new HashMap<Character, RecipeChoice.ExactChoice>();
        for (String text2 : keys) {
            void var12_16;
            char key;
            String[] parsed = text2.split(":");
            boolean assertMaterial = parsed[0].startsWith("~");
            char c = key = assertMaterial ? parsed[0].charAt(1) : parsed[0].charAt(0);
            if (keyMap.containsKey(Character.valueOf(key))) {
                LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": You have already registered this character as a key, keys must be unique!");
                return null;
            }
            try {
                Material material = Material.valueOf((String)parsed[1].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                Object var12_18 = null;
            }
            if (assertMaterial && var12_16 != null) {
                keyMap.put(Character.valueOf(key), new RecipeChoice.ExactChoice(new ItemStack((Material)var12_16)));
            } else if (assertMaterial) {
                LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": You have asserted that the provided key was to represent a material, however no such material exists!");
                return null;
            }
            CustomItem item = InnovativeItems.getInstance().getItemCache().getItem(parsed[1]);
            if (var12_16 == null && item == null) {
                LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": The object you provided for the key of " + key + " was invalid!");
                return null;
            }
            keyMap.put(Character.valueOf(key), new RecipeChoice.ExactChoice(item != null ? item.getItemStack() : new ItemStack((Material)var12_16)));
        }
        if (!recipeSection.isList("shape")) {
            LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": A shape grid is required when making a custom crafting recipe! Please review the documentation for the correct syntax and layout...");
            return null;
        }
        List shape = recipeSection.getStringList("shape");
        if (shape.size() > 3 || shape.size() < 1 || shape.stream().anyMatch(text -> text.length() > 3 || text.length() < 1)) {
            LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": The shape grid must not be greater than three, but must at least have a length of one! The contents of the grid must be three characters long, each being valid keys!");
            return null;
        }
        HashSet<Character> presentKeys = new HashSet<Character>();
        int lastSize = -1;
        for (String row : shape) {
            if (lastSize != -1 && lastSize != row.length()) {
                LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": The shape grid must be rectangular");
                return null;
            }
            lastSize = row.length();
            for (char character : row.toCharArray()) {
                if (character == ' ') continue;
                presentKeys.add(Character.valueOf(character));
            }
        }
        if (!presentKeys.equals(keyMap.keySet())) {
            LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": The shape grid must both contain all specified keys in the key section and must not contain any unidentified keys with the exception of whitespace which is equal to air!");
            return null;
        }
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)InnovativeItems.getInstance(), "innovativeplugin-customitem-" + itemName + "-recipe." + count), underlying);
        recipe.shape(shape.toArray(new String[0]));
        for (Map.Entry entry : keyMap.entrySet()) {
            recipe.setIngredient(((Character)entry.getKey()).charValue(), (RecipeChoice)entry.getValue());
        }
        return recipe;
    }

    @Nullable
    private static CookingRecipe<?> parseCookingRecipe(@NotNull ConfigurationSection recipeSection, @NotNull String itemName, @NotNull String recipeName, @NotNull ItemStack underlying, @NotNull RecipeType type, int count) {
        FurnaceRecipe recipe;
        Material material;
        if (type != RecipeType.FURNACE && type != RecipeType.BLAST_FURNACE && type != RecipeType.SMOKER && type != RecipeType.CAMPFIRE) {
            return null;
        }
        if (!recipeSection.isString("key")) {
            LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": Every cooking recipe must contain a valid key field that contains a material or custom item!");
            return null;
        }
        String rawKey = recipeSection.getString("key");
        boolean assertMaterial = rawKey.startsWith("~");
        RecipeChoice.ExactChoice key = null;
        if (assertMaterial) {
            rawKey = rawKey.substring(1);
        }
        try {
            material = Material.valueOf((String)rawKey);
        }
        catch (IllegalArgumentException e) {
            material = null;
        }
        if (assertMaterial && material != null) {
            key = new RecipeChoice.ExactChoice(new ItemStack(material));
        } else if (assertMaterial) {
            LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": You have asserted that the provided key was to represent a material, however no such material exists!");
            return null;
        }
        CustomItem item = InnovativeItems.getInstance().getItemCache().getItem(rawKey);
        if (material == null && item == null) {
            LogUtil.log(LogUtil.Level.WARNING, "Warning on recipe " + recipeName + " on item " + itemName + ": The object you provided for one of the keys was invalid!");
            return null;
        }
        if (key == null) {
            key = new RecipeChoice.ExactChoice(item != null ? item.getItemStack() : new ItemStack(material));
        }
        float experience = (float)recipeSection.getDouble("experience", 0.0);
        int time = recipeSection.getInt("cooking-time", 60);
        NamespacedKey namespace = new NamespacedKey((Plugin)InnovativeItems.getInstance(), "innovativeplugin-customitem-" + itemName + "-recipe." + count);
        if (type == RecipeType.FURNACE) {
            recipe = new FurnaceRecipe(namespace, underlying, (RecipeChoice)key, experience, time);
        } else if (type == RecipeType.BLAST_FURNACE) {
            recipe = new BlastingRecipe(namespace, underlying, (RecipeChoice)key, experience, time);
        } else if (type == RecipeType.SMOKER) {
            recipe = new SmokingRecipe(namespace, underlying, (RecipeChoice)key, experience, time);
        } else if (type == RecipeType.CAMPFIRE) {
            recipe = new CampfireRecipe(namespace, underlying, (RecipeChoice)key, experience, time);
        } else {
            LogUtil.log(LogUtil.Level.DEV, "Warning on recipe " + recipeName + " on item " + itemName + ": An internal error occured that allowed an internal RecipeType to bypass the precondition at the top of the parseCookingRecipe method in the ItemParser class... Please report this to the developer of the plugin immediately!");
            return null;
        }
        return recipe;
    }

    public static final class SkullItem {
        public static ItemStack generateItem(@NotNull String identifier, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, @Nullable String skullName, @Nullable String base64) {
            ItemStack item = CustomItem.generateItem(identifier, Material.PLAYER_HEAD, itemName, lore, enchantments, flags, attributes, customModelData, false, 0);
            SkullMeta meta = (SkullMeta)item.getItemMeta();
            if (base64 != null) {
                SkullItem.setSkinViaBase64(meta, base64);
            }
            if (skullName != null && base64 == null) {
                meta.setOwner(skullName);
            }
            item.setItemMeta((ItemMeta)meta);
            return item;
        }

        public static void setSkinViaBase64(@NotNull SkullMeta meta, @NotNull String base64) {
            block2: {
                try {
                    Method setProfile = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                    setProfile.setAccessible(true);
                    GameProfile profile = new GameProfile(UUID.randomUUID(), "skull-texture");
                    profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
                    setProfile.invoke((Object)meta, profile);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LogUtil.log(LogUtil.Level.SEVERE, "There was a severe internal reflection error when attempting to set the skin of a player skull via base64!");
                    if (InnovativeItems.getInstance().getConfigManager().getDebugLevel() < LogUtil.Level.DEV.getDebugLevel()) break block2;
                    e.printStackTrace();
                }
            }
        }
    }

    public static final class ShieldItem {
        public static ItemStack generateItem(@NotNull String identifier, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, int durability, @Nullable List<Pattern> patterns, @Nullable DyeColor baseColor) {
            ItemStack item = CustomItem.generateItem(identifier, Material.SHIELD, itemName, lore, enchantments, flags, attributes, customModelData, false, durability);
            BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
            Banner banner = (Banner)meta.getBlockState();
            if (baseColor != null) {
                banner.setBaseColor(baseColor);
            }
            if (patterns != null) {
                banner.setPatterns(patterns);
            }
            banner.update();
            meta.setBlockState((BlockState)banner);
            item.setItemMeta((ItemMeta)meta);
            return item;
        }
    }

    public static final class PotionItem {
        public static ItemStack generateItem(@NotNull String identifier, @NotNull Material material, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, @Nullable Color rgb, @Nullable Color color, @Nullable List<PotionEffect> effects) {
            if (!PotionItem.isPotion(material)) {
                LogUtil.log(LogUtil.Level.DEV, "Error while loading item " + identifier + " because material is not an instance of a potion!");
                throw new IllegalArgumentException("Illegal material provided in CustomItemPotion constructor");
            }
            ItemStack item = CustomItem.generateItem(identifier, material, itemName, lore, enchantments, flags, attributes, customModelData, false, 0);
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            if (rgb != null) {
                meta.setColor(rgb);
            }
            if (color != null && rgb == null) {
                meta.setColor(color);
            }
            if (effects != null) {
                for (PotionEffect effect : effects) {
                    meta.addCustomEffect(effect, true);
                }
            }
            item.setItemMeta((ItemMeta)meta);
            return item;
        }

        public static boolean isPotion(@NotNull Material material) {
            return material == Material.POTION || material == Material.LINGERING_POTION || material == Material.SPLASH_POTION;
        }
    }

    public static final class LeatherArmorItem {
        public static ItemStack generateItem(@NotNull String identifier, @NotNull Material material, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, boolean unbreakable, int durability, @Nullable Color rgb, @Nullable Color color) {
            if (!LeatherArmorItem.isLeatherArmor(material)) {
                LogUtil.log(LogUtil.Level.DEV, "Error while loading item " + identifier + " because material is not an instance of leather armor!");
                throw new IllegalArgumentException("Illegal material provided in CustomItemLeatherArmor constructor");
            }
            ItemStack item = CustomItem.generateItem(identifier, material, itemName, lore, enchantments, flags, attributes, customModelData, unbreakable, durability);
            LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
            if (rgb != null) {
                meta.setColor(rgb);
            }
            if (color != null && rgb == null) {
                meta.setColor(color);
            }
            item.setItemMeta((ItemMeta)meta);
            return item;
        }

        public static boolean isLeatherArmor(@NotNull Material material) {
            return material == Material.LEATHER_HELMET || material == Material.LEATHER_CHESTPLATE || material == Material.LEATHER_LEGGINGS || material == Material.LEATHER_BOOTS;
        }
    }

    public static final class FireworkItem {
        public static ItemStack generateItem(@NotNull String identifier, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, @Nullable List<FireworkEffect> fireworkEffects, @Nullable Integer power) {
            ItemStack item = CustomItem.generateItem(identifier, Material.FIREWORK_ROCKET, itemName, lore, enchantments, flags, attributes, customModelData, false, 0);
            FireworkMeta meta = (FireworkMeta)item.getItemMeta();
            if (fireworkEffects != null) {
                meta.addEffects(fireworkEffects);
            }
            if (power != null) {
                meta.setPower(power.intValue());
            }
            item.setItemMeta((ItemMeta)meta);
            return item;
        }
    }

    public static final class BannerItem {
        public static ItemStack generateItem(@NotNull String identifier, @NotNull Material material, @Nullable String itemName, @Nullable List<String> lore, @Nullable Map<Enchantment, Integer> enchantments, @Nullable List<ItemFlag> flags, @Nullable Multimap<Attribute, AttributeModifier> attributes, @Nullable Integer customModelData, int durability, @Nullable List<Pattern> patterns) {
            if (!BannerItem.isBanner(material)) {
                LogUtil.log(LogUtil.Level.DEV, "Error while loading item " + identifier + " because material is not an instance of a banner!");
                throw new IllegalArgumentException("Illegal material provided in CustomItemBanner constructor");
            }
            ItemStack item = CustomItem.generateItem(identifier, material, itemName, lore, enchantments, flags, attributes, customModelData, false, durability);
            BannerMeta meta = (BannerMeta)item.getItemMeta();
            if (patterns != null) {
                meta.setPatterns(patterns);
            }
            item.setItemMeta((ItemMeta)meta);
            return item;
        }

        public static boolean isBanner(@NotNull Material material) {
            return material == Material.BLACK_BANNER || material == Material.BLUE_BANNER || material == Material.BROWN_BANNER || material == Material.CYAN_BANNER || material == Material.GRAY_BANNER || material == Material.GREEN_BANNER || material == Material.LIGHT_BLUE_BANNER || material == Material.LIGHT_GRAY_BANNER || material == Material.LIME_BANNER || material == Material.PINK_BANNER || material == Material.MAGENTA_BANNER || material == Material.WHITE_BANNER || material == Material.ORANGE_BANNER || material == Material.RED_BANNER || material == Material.YELLOW_BANNER || material == Material.PURPLE_BANNER;
        }
    }
}

