/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.config;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.config.AbilityParser;
import me.boboballoon.innovativeitems.config.ItemParser;
import me.boboballoon.innovativeitems.items.GarbageCollector;
import me.boboballoon.innovativeitems.items.InnovativeCache;
import me.boboballoon.innovativeitems.items.ItemDefender;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.items.item.RecipeType;
import me.boboballoon.innovativeitems.util.LogUtil;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigManager {
    private static final ImmutableList<String> DEFAULT_ABILITIES = ImmutableList.of((Object)"fairy-fullset", (Object)"fairy-fullset-buff", (Object)"fairy-fullset-safety", (Object)"fairy-attack", (Object)"fairy-healing");
    private static final int MAX_FREE_ABILITIES = 15;
    private boolean checkForUpdates;
    private boolean generateDefaultConfigs;
    private boolean strict;
    private String failedItemPlaceMessage;
    private int debugLevel;
    private boolean shouldUpdateLocal;
    private boolean shouldDeleteLocal;
    private boolean itemDefenderEnabledLocal;

    public ConfigManager() {
        this.reloadMainConfigValues();
    }

    public void reloadMainConfigValues() {
        boolean enabled;
        boolean shouldDelete;
        boolean shouldUpdate;
        int debugLevel;
        String failedItemPlaceMessage;
        boolean strict;
        boolean generateDefaultConfigs;
        boolean checkForUpdates;
        InnovativeItems plugin = InnovativeItems.getInstance();
        plugin.saveDefaultConfig();
        FileConfiguration config = plugin.getConfig();
        if (config.isBoolean("check-for-updates")) {
            checkForUpdates = config.getBoolean("check-for-updates");
        } else {
            checkForUpdates = true;
            config.set("check-for-updates", (Object)true);
        }
        this.setCheckForUpdates(checkForUpdates);
        if (config.isBoolean("generate-default-configs")) {
            generateDefaultConfigs = config.getBoolean("generate-default-configs");
        } else {
            generateDefaultConfigs = true;
            config.set("generate-default-configs", (Object)true);
        }
        this.setGenerateDefaultConfigs(generateDefaultConfigs);
        if (config.isBoolean("strict")) {
            strict = config.getBoolean("strict");
        } else {
            strict = true;
            config.set("strict", (Object)true);
        }
        this.setStrict(strict);
        if (config.isString("failed-item-place")) {
            failedItemPlaceMessage = config.getString("failed-item-place", "null");
        } else {
            failedItemPlaceMessage = "null";
            config.set("failed-item-place", (Object)"null");
        }
        this.setFailedItemPlaceMessage(failedItemPlaceMessage);
        if (config.isInt("debug-level")) {
            debugLevel = config.getInt("debug-level");
        } else {
            debugLevel = 2;
            config.set("debug-level", (Object)2);
        }
        this.setDebugLevel(debugLevel, false);
        if (config.isBoolean("garbage-collector.should-update")) {
            shouldUpdate = config.getBoolean("garbage-collector.should-update");
        } else {
            shouldUpdate = true;
            config.set("garbage-collector.should-update", (Object)true);
        }
        this.setShouldUpdate(shouldUpdate);
        if (config.isBoolean("garbage-collector.should-delete")) {
            shouldDelete = config.getBoolean("garbage-collector.should-delete");
        } else {
            shouldDelete = true;
            config.set("garbage-collector.should-delete", (Object)true);
        }
        this.setShouldDelete(shouldDelete);
        if (config.isBoolean("item-defender.enabled")) {
            enabled = config.getBoolean("item-defender.enabled");
        } else {
            enabled = true;
            config.set("item-defender.enabled", (Object)true);
        }
        this.setIsItemDefenderEnabled(enabled);
        plugin.saveConfig();
    }

    public boolean shouldCheckForUpdates() {
        return this.checkForUpdates;
    }

    public void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
    }

    public boolean shouldGenerateDefaultConfigs() {
        return this.generateDefaultConfigs;
    }

    public void setGenerateDefaultConfigs(boolean generateDefaultConfigs) {
        this.generateDefaultConfigs = generateDefaultConfigs;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @NotNull
    public String getFailedItemPlaceMessage() {
        return this.failedItemPlaceMessage;
    }

    public void setFailedItemPlaceMessage(@NotNull String failedItemPlaceMessage) {
        this.failedItemPlaceMessage = TextUtil.format(failedItemPlaceMessage);
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel, boolean saveConfig) {
        this.debugLevel = Math.max(Math.min(debugLevel, 5), 0);
        if (!saveConfig) {
            return;
        }
        InnovativeItems plugin = InnovativeItems.getInstance();
        FileConfiguration config = plugin.getConfig();
        config.set("debug-level", (Object)this.debugLevel);
        plugin.saveConfig();
    }

    public boolean isItemDefenderEnabled() {
        return this.itemDefenderEnabledLocal;
    }

    public void setIsItemDefenderEnabled(boolean itemDefenderEnabled) {
        this.itemDefenderEnabledLocal = itemDefenderEnabled;
    }

    public boolean shouldUpdateItems() {
        return this.shouldUpdateLocal;
    }

    public void setShouldUpdate(boolean shouldUpdate) {
        this.shouldUpdateLocal = shouldUpdate;
    }

    public boolean shouldDeleteItems() {
        return this.shouldDeleteLocal;
    }

    public void setShouldDelete(boolean shouldDelete) {
        this.shouldDeleteLocal = shouldDelete;
    }

    public void reload() {
        LogUtil.logUnblocked(LogUtil.Level.INFO, "Starting plugin reload in five seconds, some bugs may occur during this time...");
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)InnovativeItems.getInstance(), () -> {
            InnovativeItems plugin = InnovativeItems.getInstance();
            LogUtil.log(LogUtil.Level.INFO, "Temporarily disabling garbage collector...");
            GarbageCollector garbageCollector = plugin.getGarbageCollector();
            garbageCollector.setEnabled(false);
            LogUtil.log(LogUtil.Level.INFO, "Starting basic config reload...");
            plugin.reloadConfig();
            this.reloadMainConfigValues();
            LogUtil.log(LogUtil.Level.INFO, "Basic config reload complete!");
            LogUtil.log(LogUtil.Level.INFO, "Starting cache invalidation...");
            InnovativeCache cache = plugin.getItemCache();
            for (CustomItem item : cache.getItems()) {
                ImmutableList<Recipe> recipes = item.getRecipes();
                if (recipes == null) continue;
                Bukkit.getScheduler().runTask((Plugin)InnovativeItems.getInstance(), () -> {
                    for (Recipe recipe : recipes) {
                        if (!(recipe instanceof Keyed)) {
                            LogUtil.log(LogUtil.Level.DEV, "An internal error has occurred, the recipe registered on the " + item.getIdentifier() + " item does not implement the keyed interface!");
                            return;
                        }
                        Keyed keyed = (Keyed)recipe;
                        if (Bukkit.removeRecipe((NamespacedKey)keyed.getKey())) continue;
                        LogUtil.log(LogUtil.Level.WARNING, "An error occurred while trying to unregister the custom crafting recipe for the " + item.getIdentifier() + " custom item!");
                    }
                });
            }
            cache.clearCache();
            plugin.getAbilityTimerManager().clearCache();
            LogUtil.log(LogUtil.Level.INFO, "Cache invalidation complete!");
            this.init();
            LogUtil.log(LogUtil.Level.INFO, "Updating garbage collector settings to match config...");
            garbageCollector.setShouldUpdate(this.shouldUpdateLocal);
            garbageCollector.setShouldDelete(this.shouldDeleteLocal);
            LogUtil.log(LogUtil.Level.INFO, "Garbage collector settings now match config!");
            LogUtil.log(LogUtil.Level.INFO, "Re-enabling garbage collector!");
            garbageCollector.setEnabled(true);
            Bukkit.getScheduler().runTask((Plugin)InnovativeItems.getInstance(), () -> garbageCollector.cleanAllPlayerInventories(true));
            LogUtil.log(LogUtil.Level.INFO, "Updating item defender to match config...");
            ItemDefender itemDefender = plugin.getItemDefender();
            itemDefender.setEnabled(this.itemDefenderEnabledLocal);
            LogUtil.log(LogUtil.Level.INFO, "Item defender settings now match config!");
            LogUtil.logUnblocked(LogUtil.Level.INFO, "Plugin reload complete!");
        }, 100L);
    }

    public void init() {
        LogUtil.logUnblocked(LogUtil.Level.INFO, "Starting basic plugin initialization...");
        InnovativeItems plugin = InnovativeItems.getInstance();
        LogUtil.log(LogUtil.Level.INFO, "Starting directory initialization...");
        File home = plugin.getDataFolder();
        File items = new File(home, "items");
        File abilities = new File(home, "abilities");
        if (!home.exists()) {
            home.mkdir();
        }
        if (!items.exists()) {
            items.mkdir();
        }
        if (!abilities.exists()) {
            abilities.mkdir();
        }
        LogUtil.log(LogUtil.Level.INFO, "Directory initialization complete!");
        if (this.generateDefaultConfigs) {
            this.generateDefaultConfigs(plugin, abilities, items);
        }
        InnovativeCache cache = plugin.getItemCache();
        this.loadAbilities(abilities, cache);
        this.loadItems(items, cache);
        LogUtil.logUnblocked(LogUtil.Level.INFO, "Basic plugin initialization complete!");
    }

    private void generateDefaultConfigs(@NotNull InnovativeItems plugin, @NotNull File abilities, @NotNull File items) {
        LogUtil.log(LogUtil.Level.INFO, "Starting default configuration generation...");
        File defaultAbilities = new File(abilities, "default-abilities.yml");
        File defaultItems = new File(items, "default-items.yml");
        try {
            if (!defaultAbilities.exists()) {
                defaultAbilities.createNewFile();
                Files.copy(plugin.getResource("default-abilities.yml"), defaultAbilities.toPath(), StandardCopyOption.REPLACE_EXISTING);
                LogUtil.log(LogUtil.Level.INFO, "Created a new default abilities file!");
            }
            if (!defaultItems.exists()) {
                defaultItems.createNewFile();
                Files.copy(plugin.getResource("default-items.yml"), defaultItems.toPath(), StandardCopyOption.REPLACE_EXISTING);
                LogUtil.log(LogUtil.Level.INFO, "Created a new default items file!");
            }
        }
        catch (IOException e) {
            LogUtil.log(LogUtil.Level.SEVERE, "There was an error trying to write a new file to disk...");
            if (this.debugLevel >= LogUtil.Level.DEV.getDebugLevel()) {
                e.printStackTrace();
            }
            LogUtil.log(LogUtil.Level.INFO, "Configuration generation failed...");
            return;
        }
        LogUtil.log(LogUtil.Level.INFO, "Configuration generation complete!");
    }

    private void loadAbilities(@NotNull File home, @NotNull InnovativeCache cache) {
        LogUtil.log(LogUtil.Level.INFO, "Starting ability initialization and parsing...");
        int registered = 0;
        for (File file : home.listFiles()) {
            YamlConfiguration configuration = new YamlConfiguration();
            try {
                configuration.load(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                LogUtil.log(LogUtil.Level.SEVERE, "A " + e.getClass().getSimpleName() + " occurred while loading " + file.getName() + " during ability initialization and parsing stage!");
                if (this.getDebugLevel() < LogUtil.Level.DEV.getDebugLevel()) continue;
                e.printStackTrace();
                continue;
            }
            for (String key : configuration.getKeys(false)) {
                boolean register;
                if (!InnovativeItems.isPluginPremium() && registered >= 15) {
                    LogUtil.logUnblocked(LogUtil.Level.WARNING, "You have reached the maximum amount of abilities for the free version of the plugin! Skipping the ability identified as: " + key);
                    continue;
                }
                ConfigurationSection section = configuration.getConfigurationSection(key);
                if (section == null || !(register = AbilityParser.buildAbility(section, cache)) || this.generateDefaultConfigs && DEFAULT_ABILITIES.contains((Object)key)) continue;
                ++registered;
            }
        }
        LogUtil.log(LogUtil.Level.INFO, "Ability initialization and parsing complete!");
    }

    private void loadItems(@NotNull File home, @NotNull InnovativeCache cache) {
        LogUtil.log(LogUtil.Level.INFO, "Starting item initialization and parsing...");
        LinkedList<ItemNode> nodes = new LinkedList<ItemNode>();
        for (File file : home.listFiles()) {
            YamlConfiguration configuration = new YamlConfiguration();
            try {
                configuration.load(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                LogUtil.log(LogUtil.Level.WARNING, "A " + e.getClass().getSimpleName() + " occurred while loading " + file.getName() + " during item initialization and parsing stage!");
                if (this.getDebugLevel() < LogUtil.Level.DEV.getDebugLevel()) continue;
                e.printStackTrace();
                continue;
            }
            for (String key : configuration.getKeys(false)) {
                ConfigurationSection section = configuration.getConfigurationSection(key);
                if (section == null) continue;
                String name = section.getName();
                if (cache.contains(name)) {
                    LogUtil.log(LogUtil.Level.WARNING, "Element with the name of " + name + ", is already registered! Skipping item...");
                    continue;
                }
                nodes.add(new ItemNode(section));
            }
        }
        for (ItemNode node2 : nodes) {
            node2.findDependantItems(cache, nodes);
        }
        while (!nodes.isEmpty()) {
            Optional<ItemNode> current = nodes.stream().filter(node -> node.getDependantItems().size() <= 0).findAny();
            if (!current.isPresent()) {
                LogUtil.logUnblocked(LogUtil.Level.SEVERE, "A cycle has been found in the heap of custom items! You are not allowed to have two items that depend on each other or an item that depends on itself as that would cause an infinite loop!");
                break;
            }
            ItemNode node3 = current.get();
            for (ItemNode parent : nodes) {
                parent.getDependantItems().remove(node3.getIdentifier());
            }
            nodes.remove(node3);
            LogUtil.log(LogUtil.Level.NOISE, "Parsing item: " + node3.getIdentifier());
            CustomItem item = ItemParser.parseItem(node3.getConfigurationSection(), node3.getIdentifier());
            if (item != null) {
                cache.registerItem(item);
                LogUtil.log(LogUtil.Level.NOISE, "Registered item: " + node3.getIdentifier());
                continue;
            }
            LogUtil.log(LogUtil.Level.NOISE, "Failed to register item: " + node3.getIdentifier());
        }
        if (nodes.isEmpty()) {
            LogUtil.log(LogUtil.Level.INFO, "Item initialization and parsing complete!");
            return;
        }
        LogUtil.logUnblocked(LogUtil.Level.SEVERE, "As a cycle was detected all items will be loaded without custom crafting recipes!");
        for (ItemNode node4 : nodes) {
            CustomItem item = ItemParser.parseItem(node4.getConfigurationSection(), node4.getIdentifier(), false);
            if (item != null) {
                cache.registerItem(item);
                LogUtil.log(LogUtil.Level.NOISE, "Registered item: " + node4.getIdentifier());
                continue;
            }
            LogUtil.log(LogUtil.Level.NOISE, "Failed to register item: " + node4.getIdentifier());
        }
        LogUtil.log(LogUtil.Level.INFO, "Item initialization and parsing complete!");
    }

    private static final class ItemNode {
        private final ConfigurationSection section;
        private final String identifier;
        private Set<String> dependantItems;

        public ItemNode(@NotNull ConfigurationSection section) {
            this.section = section;
            this.identifier = section.getName();
            this.dependantItems = null;
        }

        @NotNull
        public ConfigurationSection getConfigurationSection() {
            return this.section;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }

        @Nullable
        public Set<String> getDependantItems() {
            return this.dependantItems;
        }

        public void findDependantItems(@NotNull InnovativeCache cache, @NotNull LinkedList<ItemNode> nodes) {
            HashSet<String> dependantItems = new HashSet<String>();
            if (!this.section.isConfigurationSection("recipes")) {
                this.dependantItems = dependantItems;
                return;
            }
            ConfigurationSection recipes = this.section.getConfigurationSection("recipes");
            for (String recipeName : recipes.getKeys(false)) {
                List<String> keys;
                boolean isCookingRecipe;
                RecipeType type;
                ConfigurationSection recipe;
                if (!recipes.isConfigurationSection(recipeName) || !(recipe = recipes.getConfigurationSection(recipeName)).isString("type")) continue;
                try {
                    type = RecipeType.valueOf(recipe.getString("type").toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                boolean bl = isCookingRecipe = type == RecipeType.FURNACE || type == RecipeType.BLAST_FURNACE || type == RecipeType.SMOKER || type == RecipeType.CAMPFIRE;
                if (type == RecipeType.SHAPED && (!recipe.isList("keys") || !recipe.isList("shape")) || isCookingRecipe && !recipe.isString("key")) continue;
                List<String> list = type == RecipeType.SHAPED ? recipe.getStringList("keys") : (keys = isCookingRecipe ? Collections.singletonList(recipe.getString("key")) : null);
                if (keys == null) {
                    LogUtil.log(LogUtil.Level.DEV, "Error on item " + this.identifier + " on recipe " + recipeName + ": An unknown RecipeType was found with no implementation on creating a snapshot with the purpose of creating a list of dependant items!");
                    continue;
                }
                for (String key : keys) {
                    String rawId;
                    String regex;
                    if (key.startsWith("~")) continue;
                    String string = regex = type == RecipeType.SHAPED ? "\\w:.+" : null;
                    if (regex != null && !key.matches(regex)) continue;
                    String string2 = rawId = type == RecipeType.SHAPED ? key.split(":")[1] : key;
                    if (cache.getItem(rawId) == null && !nodes.stream().anyMatch(node -> node.getIdentifier().equals(rawId))) continue;
                    dependantItems.add(rawId);
                }
            }
            this.dependantItems = dependantItems;
        }
    }
}

