/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.command;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CatchUnknown;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Conditions;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Subcommand;
import java.util.Arrays;
import java.util.List;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.config.ConfigManager;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.ui.ItemBuilderView;
import me.boboballoon.innovativeitems.util.InventoryUtil;
import me.boboballoon.innovativeitems.util.TextUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="innovativeitems||ii")
@CommandPermission(value="innovativeitems.command")
public class InnovativeItemsCommand
extends BaseCommand {
    private static final List<String> HELP_MESSAGE = Arrays.asList(StringUtils.center((String)TextUtil.format("&r&e&lAvailable Commands:"), (int)40), TextUtil.format("&r&e&l- /innovativeitems get <item> <amount>"), TextUtil.format("&r&e&l- /innovativeitems give <player> <item> <amount>"), TextUtil.format("&r&e&l- /innovativeitems debug <level>"), TextUtil.format("&r&e&l- /innovativeitems reload"), TextUtil.format("&r&e&l- /innovativeitems execute <ability> <player>"), TextUtil.format("&r&e&l- /innovativeitems clean <player>"), TextUtil.format("&r&e&l- /innovativeitems create <item-identifier>"));

    @CatchUnknown
    @Default
    public void onHelp(CommandSender sender) {
        for (String line : HELP_MESSAGE) {
            sender.sendMessage(line);
        }
    }

    @Subcommand(value="get")
    @Conditions(value="is-player")
    @CommandCompletion(value="@valid-items @range:1-64 @nothing")
    public void onGetItem(Player player, String[] args) {
        if (args.length < 1 || args.length > 2) {
            TextUtil.sendMessage((CommandSender)player, "&r&cYou have entered improper arguments to execute this command!");
            this.onHelp((CommandSender)player);
            return;
        }
        CustomItem customItem = InnovativeItems.getInstance().getItemCache().getItem(args[0]);
        if (customItem == null) {
            TextUtil.sendMessage((CommandSender)player, "&r&cYou have entered an item that does not exist!");
            return;
        }
        int amount = 1;
        if (args.length == 2) {
            try {
                amount = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                amount = 0;
            }
            if (amount <= 0 || amount >= 1000) {
                TextUtil.sendMessage((CommandSender)player, "&r&cYou have entered an invalid amount!");
                return;
            }
        }
        InventoryUtil.giveItem(player, customItem.getItemStack(), amount);
        TextUtil.sendMessage((CommandSender)player, "&r&aAdded " + amount + " " + customItem.getIdentifier() + " to your inventory!");
    }

    @Subcommand(value="give")
    @CommandCompletion(value="@players @valid-items @range:1-64 @nothing")
    public void onGiveItem(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 2 || args.length > 4) {
            TextUtil.sendMessage(sender, "&r&cYou have entered improper arguments to execute this command!");
            this.onHelp(sender);
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            TextUtil.sendMessage(sender, "&r&cYou have entered the name of a player that is not online!");
            return;
        }
        CustomItem customItem = InnovativeItems.getInstance().getItemCache().getItem(args[1]);
        if (customItem == null) {
            TextUtil.sendMessage(sender, "&r&cYou have entered an item that does not exist!");
            return;
        }
        try {
            amount = args.length > 2 ? Integer.parseInt(args[2]) : 1;
        }
        catch (NumberFormatException e) {
            TextUtil.sendMessage(sender, "&r&cYou have entered an invalid amount!");
            return;
        }
        InventoryUtil.giveItem(target, customItem.getItemStack(), amount);
        TextUtil.sendMessage(sender, "&r&aGave " + amount + " " + customItem.getIdentifier() + " to " + target.getName() + "!");
    }

    @Subcommand(value="debug")
    @CommandCompletion(value="@range:0-5 @nothing")
    public void onDebug(CommandSender sender, String[] args) {
        int level;
        if (args.length != 1) {
            TextUtil.sendMessage(sender, "&r&cYou have entered improper arguments to execute this command!");
            this.onHelp(sender);
            return;
        }
        try {
            level = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ignore) {
            TextUtil.sendMessage(sender, "&r&cYou have entered an invalid number!");
            return;
        }
        ConfigManager configManager = InnovativeItems.getInstance().getConfigManager();
        configManager.setDebugLevel(level, true);
        TextUtil.sendMessage(sender, "&r&aYou have set the debug level to " + configManager.getDebugLevel() + "!");
    }

    @Subcommand(value="reload")
    @CommandCompletion(value="@nothing")
    public void onReload(CommandSender sender) {
        if (sender instanceof Player) {
            TextUtil.sendMessage(sender, "&r&aStarting asynchronous reload in five seconds!");
        }
        InnovativeItems.getInstance().getConfigManager().reload();
    }

    @Subcommand(value="execute")
    @CommandCompletion(value="@valid-abilities @players @nothing")
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length < 1 || args.length > 2) {
            TextUtil.sendMessage(sender, "&r&cYou have entered improper arguments to execute this command!");
            this.onHelp(sender);
            return;
        }
        if (args.length != 2 && !(sender instanceof Player)) {
            TextUtil.sendMessage(sender, "&r&cYou must be a player to execute this command without a target!");
            this.onHelp(sender);
            return;
        }
        Ability ability = InnovativeItems.getInstance().getItemCache().getAbility(args[0]);
        if (ability == null) {
            TextUtil.sendMessage(sender, "&r&cYou have entered an ability that does not exist!");
            return;
        }
        if (ability.getTrigger().getTargeters().size() > 1 && InnovativeItems.getInstance().getConfigManager().isStrict()) {
            TextUtil.sendMessage(sender, "&r&cYou have entered an ability that is not compatible with the &l'none'&r&c trigger!");
            return;
        }
        Player target = args.length == 2 ? Bukkit.getPlayerExact((String)args[1]) : (Player)sender;
        if (target == null) {
            TextUtil.sendMessage(sender, "&r&cYou have entered the name of a player that is not online!");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)InnovativeItems.getInstance(), () -> {
            if (ability.execute(target)) {
                TextUtil.sendMessage(sender, "&r&aYou have successfully executed the " + ability.getIdentifier() + " ability!");
            } else {
                TextUtil.sendMessage(sender, "&r&aThere was an issue trying to execute the " + ability.getIdentifier() + " ability! This could be due to a condition not being met to incompatible triggers...");
            }
        });
    }

    @Subcommand(value="clean")
    @CommandCompletion(value="@players @nothing")
    public void onClean(CommandSender sender, String[] args) {
        if (args.length != 1) {
            TextUtil.sendMessage(sender, "&r&aCleaning up all players inventories!");
            InnovativeItems.getInstance().getGarbageCollector().cleanAllPlayerInventories(true);
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            TextUtil.sendMessage(sender, "&r&cYou have entered the name of a player that is not online!");
            return;
        }
        TextUtil.sendMessage((CommandSender)target, "&r&aCleaning up the inventory of a player by the name of " + target.getName() + "!");
        InnovativeItems.getInstance().getGarbageCollector().cleanInventory((Inventory)target.getInventory(), true);
    }

    @Subcommand(value="create")
    @Conditions(value="is-player")
    @CommandCompletion(value="@nothing")
    public void onItemCreate(Player player, String[] args) {
        if (args.length != 1) {
            TextUtil.sendMessage((CommandSender)player, "&r&cYou have entered improper arguments to execute this command!");
            this.onHelp((CommandSender)player);
            return;
        }
        ItemBuilderView builder = new ItemBuilderView(args[0]);
        builder.open(player);
    }
}

