/*
 * Decompiled with CFR 0.152.
 */
package me.boboballoon.innovativeitems.api;

import java.util.Optional;
import me.boboballoon.innovativeitems.InnovativeItems;
import me.boboballoon.innovativeitems.config.ConfigManager;
import me.boboballoon.innovativeitems.functions.FunctionManager;
import me.boboballoon.innovativeitems.items.GarbageCollector;
import me.boboballoon.innovativeitems.items.ItemDefender;
import me.boboballoon.innovativeitems.items.ability.Ability;
import me.boboballoon.innovativeitems.items.item.CustomItem;
import me.boboballoon.innovativeitems.util.LogUtil;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class InnovativeItemsAPI {
    private InnovativeItemsAPI() {
    }

    @NotNull
    public static FunctionManager getFunctionManager() {
        return InnovativeItems.getInstance().getFunctionManager();
    }

    @NotNull
    public static ConfigManager getConfigManager() {
        ConfigManager manager = InnovativeItems.getInstance().getConfigManager();
        if (manager == null) {
            throw new IllegalStateException("You tried to access the plugin's config manager before the plugin was enabled!");
        }
        return manager;
    }

    @NotNull
    public static GarbageCollector getGarbageCollector() {
        GarbageCollector garbage = InnovativeItems.getInstance().getGarbageCollector();
        if (garbage == null) {
            throw new IllegalStateException("You tried to access the plugin's garbage collector before the plugin was enabled!");
        }
        return garbage;
    }

    @NotNull
    public static ItemDefender getItemDefender() {
        ItemDefender defender = InnovativeItems.getInstance().getItemDefender();
        if (defender == null) {
            throw new IllegalStateException("You tried to access the plugin's item defender before the plugin was enabled!");
        }
        return defender;
    }

    public static void log(@NotNull LogUtil.Level level, @NotNull String text, boolean ignoreDebugLevel) {
        if (ignoreDebugLevel) {
            LogUtil.logUnblocked(level, text);
            return;
        }
        InnovativeItemsAPI.log(level, text);
    }

    public static void log(@NotNull LogUtil.Level level, @NotNull String text) {
        LogUtil.log(level, text);
    }

    public static boolean executeAbility(@NotNull String identifier, @NotNull Player player) {
        return InnovativeItemsAPI.executeAbility(identifier, player, true);
    }

    public static boolean executeAbility(@NotNull String identifier, @NotNull Player player, boolean silent) {
        Ability ability = InnovativeItems.getInstance().getItemCache().getAbility(identifier);
        if (ability != null) {
            return ability.execute(player);
        }
        if (silent) {
            return false;
        }
        throw new IllegalArgumentException("The provided identifier: " + identifier + ", does not belong to any currently loaded ability!");
    }

    @NotNull
    public static Optional<CustomItem> getCustomItem(@NotNull String identifier) {
        CustomItem item = InnovativeItems.getInstance().getItemCache().getItem(identifier);
        return Optional.ofNullable(item);
    }

    @NotNull
    public static Optional<Ability> getAbility(@NotNull String identifier) {
        Ability ability = InnovativeItems.getInstance().getItemCache().getAbility(identifier);
        return Optional.ofNullable(ability);
    }
}

