/*
 * Decompiled with CFR 0.152.
 */
package com.klapeks.coserver.plugin.bungee;

import com.klapeks.coserver.dCoserverServer;
import com.klapeks.coserver.dFunctions;
import java.net.Socket;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SuperCoServer
extends dCoserverServer {
    public static SuperCoServer BungeeCoserv;
    private HashMap<String, Function<String, String>> handlers = new HashMap();
    private HashMap<String, Function<String, String>> securityHandlers = new HashMap();
    private HashMap<String, BiFunction<Socket, String, String>> bi_handlers = new HashMap();
    private HashMap<String, BiFunction<Socket, String, String>> bi_securityHandlers = new HashMap();

    public void addHandler(String command, Function<String, String> func) {
        this.handlers.put(command, func);
    }

    public void addSecurityHandler(String command, Function<String, String> func) {
        this.securityHandlers.put(command, func);
    }

    public void addSocketHandler(String command, BiFunction<Socket, String, String> func) {
        this.bi_handlers.put(command, func);
    }

    public void addSocketSecurityHandler(String command, BiFunction<Socket, String, String> func) {
        this.bi_securityHandlers.put(command, func);
    }

    public SuperCoServer(int port) {
        super(port);
    }

    @Override
    public String handle(Socket socket, String request) {
        String cmd = request.split(" ")[0];
        if (this.bi_handlers.containsKey(cmd)) {
            return this.bi_handlers.get(cmd).apply(socket, request.replaceFirst(String.valueOf(cmd) + " ", ""));
        }
        return super.handle(socket, request);
    }

    @Override
    public String securityHandle(Socket socket, String request) {
        String cmd = request.split(" ")[0];
        if (this.bi_securityHandlers.containsKey(cmd)) {
            return this.bi_securityHandlers.get(cmd).apply(socket, request.replaceFirst(String.valueOf(cmd) + " ", ""));
        }
        return super.securityHandle(socket, request);
    }

    @Override
    public String handle(String request) {
        String cmd = request.split(" ")[0];
        if (this.handlers.containsKey(cmd)) {
            return this.handlers.get(cmd).apply(request.replaceFirst(String.valueOf(cmd) + " ", ""));
        }
        return super.handle(request);
    }

    @Override
    public String securityHandle(String request) {
        String cmd = request.split(" ")[0];
        if (this.securityHandlers.containsKey(cmd)) {
            return this.securityHandlers.get(cmd).apply(request.replaceFirst(String.valueOf(cmd) + " ", ""));
        }
        return super.securityHandle(request);
    }

    @Override
    public void onEnable() {
        dFunctions.log("\u00a7aSuperCoServer was enabled on port: \u00a76" + this.port);
    }
}

