/*
 * Decompiled with CFR 0.152.
 */
package com.klapeks.coserver.plugin.bungee;

import com.klapeks.coserver.aConfig;
import com.klapeks.coserver.dFunctions;
import com.klapeks.funcs.FileCfgUtils;
import com.klapeks.funcs.dRSA;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedHashMap;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class ConfigBungee {
    static final String fs = File.separator;
    private static FileWriter fw = null;
    private static Configuration config = null;

    static void __init() {
        try {
            File file = new File("plugins" + fs + "Coserver", "config.yml");
            if (!file.exists()) {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    dFunctions.debug("\u00a76Config was not found; Creating new one");
                    fw = new FileWriter(file);
                    fw.write("# Config for BungeeCord server side\n");
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
            if (fw == null) {
                fw = ConfigBungee.open(file);
            }
            aConfig.bungee.port = ConfigBungee.g("port", ConfigBungee.getDefaultPort(), "Port");
            aConfig.useSecurity = ConfigBungee.g("useSecurity", false, new String[0]);
            aConfig.rsaKeySize = ConfigBungee.g("rsaKeySize", 1024, "RSA key size");
            aConfig.securityKey = ConfigBungee.g("securityKey", dRSA.generateSecretKey(10), "Security key to send to bukkit a RSA public key", "(Needs to equals with bukkit's config file)");
            aConfig.useDebugMsg = ConfigBungee.g("useDebugMsg", false, "Is debug messages will shows in console");
            aConfig.bungee.strongDebug = ConfigBungee.g("STRONG_DEBUG", "", "Is debug messages will shows in console").equals("true");
            fw.flush();
            fw.close();
            config = null;
            fw = null;
            if (aConfig.bungee.port < 0 || aConfig.bungee.port > 65535) {
                throw new IllegalArgumentException("Port value out of range (0 <= " + aConfig.bungee.port + " <= 65535)");
            }
            if (aConfig.rsaKeySize <= 0) {
                throw new IllegalArgumentException("rsaKeySize value out of range (0 < " + aConfig.rsaKeySize + ")");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static int getBungeePort() {
        try {
            Configuration cfg = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File("config.yml"));
            LinkedHashMap m = (LinkedHashMap)cfg.getList("listeners").get(0);
            return Integer.parseInt(("" + m.get("host")).split(":")[1]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static int getDefaultPort() {
        int port = ConfigBungee.getBungeePort();
        port = port >= 3000 ? (port -= 3000) : (port >= 100 ? (port -= 100) : -1);
        return port;
    }

    private static FileWriter open(File file) {
        return FileCfgUtils.open(file);
    }

    private static <T> T g(String key, T defaultValue, String ... comment) {
        return FileCfgUtils.g(config, fw, key, defaultValue, comment);
    }
}

