/*
 * Decompiled with CFR 0.152.
 */
package com.klapeks.coserver.plugin.bukkit;

import com.klapeks.coserver.aConfig;
import com.klapeks.coserver.dFunctions;
import com.klapeks.funcs.FileCfgUtils;
import com.klapeks.funcs.dRSA;
import java.io.File;
import java.io.FileWriter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigBukkit {
    static final String fs = File.separator;
    private static FileWriter fw = null;
    private static FileConfiguration config = null;

    static void __init() {
        try {
            File file = new File("plugins" + fs + "Coserver" + fs + "config.yml");
            if (!file.exists()) {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    dFunctions.debug("\u00a76Config was not found; Creating new one");
                    fw = new FileWriter(file);
                    fw.write("# Config for Bukkit server side\n");
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            config = YamlConfiguration.loadConfiguration((File)file);
            if (fw == null) {
                fw = ConfigBukkit.open(file);
            }
            aConfig.bukkit.ip = ConfigBukkit.g("bungee.ip", "0.0.0.0", new String[0]);
            aConfig.bukkit.port = ConfigBukkit.g("bungee.port", 22565, new String[0]);
            aConfig.useSecurity = ConfigBukkit.g("useSecurity", true, new String[0]);
            aConfig.rsaKeySize = ConfigBukkit.g("rsaKeySize", 1024, "RSA key size");
            aConfig.securityKey = ConfigBukkit.g("securityKey", dRSA.generateSecretKey(10), "Security key to get a RSA public key from bungeecord", "(Needs to equals with bungeecord's config file)");
            aConfig.useDebugMsg = ConfigBukkit.g("useDebugMsg", false, "Is debug messages will shows in console");
            aConfig.shutdownOnError = ConfigBukkit.g("shutdownOnError", false, "If plugins that use CoserverAPI gets an error on startup, they will be able to shutdown server");
            fw.flush();
            fw.close();
            config = null;
            fw = null;
            if (aConfig.bukkit.port < 0 || aConfig.bukkit.port > 65535) {
                throw new IllegalArgumentException("Port value out of range (0 <= " + aConfig.bukkit.port + " <= 65535)");
            }
            if (aConfig.rsaKeySize <= 0) {
                throw new IllegalArgumentException("rsaKeySize value out of range (0 < " + aConfig.rsaKeySize + ")");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static FileWriter open(File file) {
        return FileCfgUtils.open(file);
    }

    private static <T> T g(String key, T defaultValue, String ... comment) {
        return FileCfgUtils.g(config, fw, key, defaultValue, comment);
    }
}

