/*
 * Decompiled with CFR 0.152.
 */
package com.klapeks.coserver;

import com.klapeks.coserver.aConfig;
import com.klapeks.coserver.dFunctions;
import com.klapeks.funcs.dRSA;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;

public class dCoserverServer {
    protected ServerSocket serverSocket;
    public final int port;
    private KeyPair keyPair;
    boolean disabled = false;

    public dCoserverServer(int port) {
        this.port = port;
        this.keyPair = dRSA.generateKeyPair(aConfig.rsaKeySize);
        new Thread(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    dCoserverServer.this.serverSocket = new ServerSocket(dCoserverServer.this.port);
                    dCoserverServer.this.onEnable();
                    while (!dCoserverServer.this.disabled) {
                        try {
                            dFunctions.strong_debug("Waiting for connection");
                            Socket s = dCoserverServer.this.serverSocket.accept();
                            dFunctions.strong_debug("Some socket was connected");
                            new Thread(new SocketProcessor(dCoserverServer.this, s)).start();
                        }
                        catch (Throwable th) {
                            if (dCoserverServer.this.serverSocket.isClosed() && dCoserverServer.this.disabled) return;
                            th.printStackTrace();
                        }
                    }
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }.start();
    }

    public void shutdown() {
        try {
            this.disabled = true;
            this.serverSocket.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onEnable() {
        dFunctions.log("Coserver was started with port " + this.port);
    }

    public String handle(Socket socket, String request) {
        return this.handle(request);
    }

    public String securityHandle(Socket socket, String request) {
        return this.securityHandle(request);
    }

    public String handle(String request) {
        return "null";
    }

    public String securityHandle(String request) {
        return "null";
    }

    private static class SocketProcessor
    implements Runnable {
        private Socket s;
        private dCoserverServer hs;

        public SocketProcessor(dCoserverServer hs, Socket s) {
            this.s = s;
            this.hs = hs;
        }

        private String handleRequest(Socket s, String request) {
            if (request.startsWith("enc/") || request.contains("/dec/")) {
                request = request.replaceFirst("enc/", "");
                PublicKey pk = dRSA.toPublicKey(request.split("/dec/")[0]);
                request = request.substring(request.split("/dec/")[0].length() + "/dec/".length());
                try {
                    request = dRSA.rsaDecrypt(request, this.hs.keyPair.getPrivate());
                }
                catch (Throwable t) {
                    if (aConfig.useDebugMsg) {
                        t.printStackTrace();
                        dFunctions.debug("\u00a7cErrored request -> errored response");
                    }
                    return "someerror";
                }
                return dRSA.rsaEncrypt(this.hs.securityHandle(s, request), pk);
            }
            if (request.startsWith(String.valueOf(aConfig.securityKey) + "0x25G") && (request = request.substring(request.split("0x25G")[0].length() + "0x25G".length())).startsWith("givemepswpls")) {
                return dRSA.fromKey(this.hs.keyPair.getPublic());
            }
            try {
                return this.hs.handle(s, request);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }

        static void largeResponse(DataOutputStream dout, String response) {
            int sepr = 64000;
            String nr = "";
            ArrayList<String> list = new ArrayList<String>();
            while (response.length() > 64000) {
                nr = response.substring(0, 64000);
                response = response.substring(64000);
                list.add(nr);
            }
            list.add(response);
            try {
                dout.writeUTF("[Large]Willbe:" + list.size());
                for (String s : list) {
                    dout.writeUTF(s);
                }
                dout.flush();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        @Override
        public void run() {
            try {
                DataInputStream din = new DataInputStream(this.s.getInputStream());
                DataOutputStream dout = new DataOutputStream(this.s.getOutputStream());
                boolean isLarge = false;
                String request = din.readUTF();
                dFunctions.strong_debug("Request was sended from " + this.s.getInetAddress() + ": " + request);
                if (request.startsWith("[Large]")) {
                    request = request.substring("[Large]".length());
                    isLarge = true;
                }
                String response = this.handleRequest(this.s, request);
                dFunctions.strong_debug("Response: " + response);
                if (response == null) {
                    response = "404error";
                }
                if (response.equals("someerror")) {
                    response = "Errors 400/401/403/405/417/501/503 (go away lmao)";
                }
                if (response.length() >= 64000) {
                    SocketProcessor.largeResponse(dout, response);
                } else {
                    dout.writeUTF(response);
                    dout.flush();
                }
                if (isLarge) {
                    while (true) {
                        if ((request = din.readUTF()).startsWith("[Large]")) {
                            request = request.substring("[Large]".length());
                        }
                        if (request.equals("CloseConnection")) {
                            dout.writeUTF("ty :3");
                            dout.flush();
                            break;
                        }
                        response = this.handleRequest(this.s, request);
                        if (response == null) {
                            response = "404error";
                        }
                        if (response.equals("someerror")) {
                            response = "Errors 400/401/403/405/417/501/503 (go away lmao)";
                        }
                        if (response.length() >= 64000) {
                            SocketProcessor.largeResponse(dout, response);
                            continue;
                        }
                        dout.writeUTF(response);
                        dout.flush();
                    }
                }
                dFunctions.strong_debug("Closing...");
                dout.close();
                din.close();
                this.s.close();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

