/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.utils.health;

public record HealthSetResult(int state, double oldHealth, double newHealth) {
    public static final int OK = 0;
    public static final int ABOVE_MAX = 1;
    public static final int BELOW_MIN = 2;

    public boolean isInRange() {
        return !this.isAboveMax() && !this.isBelowMin();
    }

    public boolean isAboveMax() {
        return (this.state & 1) == 1;
    }

    public boolean isBelowMin() {
        return (this.state & 2) == 2;
    }

    public String getStateString() {
        StringBuilder builder = new StringBuilder();
        if (this.isAboveMax()) {
            builder.append("ABOVE_MAX");
        }
        if (this.isBelowMin()) {
            builder.append(" && BELOW_MIN");
        }
        if (builder.length() == 0) {
            builder.append("OK");
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return "HealthSetResult[oldHealth=%s, newHealth=%s, state=%s]".formatted(this.oldHealth, this.newHealth, this.getStateString());
    }
}

