/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import me.ikevoodoo.smpcore.commands.SMPCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class CommandUtils {
    private static CommandMap map = null;
    private static Constructor<PluginCommand> constructor;

    private CommandUtils() {
    }

    public static void register(final SMPCommand command) {
        if (map == null) {
            try {
                Field f = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                f.setAccessible(true);
                map = (CommandMap)f.get(Bukkit.getServer());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            try {
                constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                constructor.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            PluginCommand cmd = constructor.newInstance(command.getName(), command.getPlugin());
            cmd.setExecutor((CommandExecutor)command);
            cmd.setTabCompleter((TabCompleter)command);
            cmd.setPermission(command.getPermission());
            map.register(command.getName(), (Command)cmd);
        }
        catch (Exception e) {
            System.err.println("Unable to register PluginCommand, defaulting to Command");
            Command cmd = new Command(command.getName()){

                public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                    return command.onCommand(sender, null, commandLabel, args);
                }
            };
            cmd.setPermission(command.getPermission());
            cmd.setLabel(command.getPlugin().getName());
            map.register(command.getName(), cmd);
        }
    }
}

