/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.text.messaging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.ikevoodoo.smpcore.text.messaging.Message;
import me.ikevoodoo.smpcore.text.messaging.MessageComponent;
import me.ikevoodoo.smpcore.text.messaging.MessageProperty;
import me.ikevoodoo.smpcore.text.messaging.TextDecorInfo;
import me.ikevoodoo.smpcore.text.messaging.utils.MessageUtils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;

public class MessageBuilder {
    private final List<MessageComponent> messageComponents = new ArrayList<MessageComponent>();

    private MessageBuilder() {
    }

    public static MessageBuilder create() {
        return new MessageBuilder();
    }

    public static Message messageOf(String text) {
        return MessageBuilder.create().add(text).build();
    }

    public static Message messageOf(Message message) {
        return MessageBuilder.create().add(message).build();
    }

    public static MessageBuilder builderOf(String text) {
        return MessageBuilder.create().add(text);
    }

    public static MessageBuilder builderOf(Message message) {
        return MessageBuilder.create().add(message);
    }

    public MessageBuilder add() {
        this.messageComponents.add(new MessageComponent());
        return this;
    }

    public MessageBuilder add(String text) {
        return this.addComponent((BaseComponent)MessageUtils.toTextComponent(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)text))));
    }

    public MessageBuilder addPlain(String text) {
        return this.add().text(text);
    }

    public MessageBuilder add(String text, ChatColor color) {
        return this.addPlain(text).color(color);
    }

    public MessageBuilder add(Message message) {
        message.components().forEach(this::addComponent);
        return this;
    }

    public MessageBuilder text(String text) {
        this.last().setText(text);
        return this;
    }

    public MessageBuilder text(String text, ChatColor color) {
        return this.text(text).color(color);
    }

    public MessageBuilder color(ChatColor color) {
        this.last().setColor(color);
        return this;
    }

    public MessageBuilder properties(MessageProperty ... properties) {
        Collections.addAll(this.last().getProperties(), properties);
        return this;
    }

    public MessageBuilder click(ClickEvent.Action action, String data) {
        this.last().setClickEvent(new ClickEvent(action, data));
        return this;
    }

    public MessageBuilder hover(HoverEvent.Action action, Content ... contents) {
        this.last().setHoverEvent(new HoverEvent(action, contents));
        return this;
    }

    public MessageBuilder link(String url) {
        return this.click(ClickEvent.Action.OPEN_URL, url);
    }

    public MessageBuilder link(String url, String text) {
        return this.addPlain(text).link(url);
    }

    public MessageBuilder link(String url, ChatColor color) {
        return this.click(ClickEvent.Action.OPEN_URL, url).color(color);
    }

    public MessageBuilder link(String url, String text, ChatColor color) {
        return this.add(text, color).link(url);
    }

    public MessageBuilder clear() {
        this.messageComponents.clear();
        return this;
    }

    public Message build() {
        ComponentBuilder componentBuilder = new ComponentBuilder();
        for (MessageComponent messageComponent : this.messageComponents) {
            componentBuilder.append(messageComponent.getText()).color(messageComponent.getColor()).event(messageComponent.getClickEvent()).event(messageComponent.getHoverEvent());
            block9: for (MessageProperty property : messageComponent.getProperties()) {
                switch (property) {
                    case BOLD: {
                        componentBuilder.bold(true);
                        continue block9;
                    }
                    case ITALIC: {
                        componentBuilder.italic(true);
                        continue block9;
                    }
                    case STRIKETHROUGH: {
                        componentBuilder.strikethrough(true);
                        continue block9;
                    }
                    case UNDERLINE: {
                        componentBuilder.underlined(true);
                        continue block9;
                    }
                    case OBFUSCATED: {
                        componentBuilder.obfuscated(true);
                        continue block9;
                    }
                    case RESET: {
                        componentBuilder.reset();
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("Unknown property: " + property);
            }
        }
        return new Message(componentBuilder.create());
    }

    private MessageComponent last() {
        if (this.messageComponents.isEmpty()) {
            throw new IllegalStateException("No components added! Did you forget to call MessageBuilder#add()?");
        }
        return this.messageComponents.get(this.messageComponents.size() - 1);
    }

    private List<TextDecorInfo> getInfo(String text) {
        int offset = 0;
        ArrayList globalProperties = new ArrayList();
        while (offset < text.length()) {
            String sub = text.substring(offset);
            if (!sub.startsWith("[[")) continue;
            String prop = sub.substring(2, Math.max(sub.indexOf(93), 1));
            System.out.println(prop);
        }
        return List.of();
    }

    private MessageBuilder addComponent(BaseComponent comp) {
        this.addPlain(comp.toLegacyText()).color(comp.getColor());
        ClickEvent event = comp.getClickEvent();
        if (event != null) {
            this.click(event.getAction(), event.getValue());
        }
        HoverEvent hoverEvent = comp.getHoverEvent();
        if (event != null) {
            this.hover(hoverEvent.getAction(), hoverEvent.getContents().toArray(new Content[0]));
        }
        if (comp.isBold()) {
            this.properties(MessageProperty.BOLD);
        }
        if (comp.isItalic()) {
            this.properties(MessageProperty.ITALIC);
        }
        if (comp.isObfuscated()) {
            this.properties(MessageProperty.OBFUSCATED);
        }
        if (comp.isStrikethrough()) {
            this.properties(MessageProperty.STRIKETHROUGH);
        }
        if (comp.isUnderlined()) {
            this.properties(MessageProperty.UNDERLINE);
        }
        return this;
    }
}

