/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.senders;

import java.util.Set;
import java.util.UUID;
import me.ikevoodoo.smpcore.senders.CustomSender;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SenderBuilder {
    public static CommandSender createNewSender(final CustomSender sender) {
        CommandSender s = sender.getSender();
        if (s == null) {
            s = Bukkit.getConsoleSender();
        }
        final CommandSender finalS = s;
        return new CommandSender(){

            public void sendMessage(@NotNull String message) {
                if (sender.isLog()) {
                    finalS.sendMessage(message);
                }
            }

            public void sendMessage(String ... messages) {
                if (sender.isLog()) {
                    finalS.sendMessage(messages);
                }
            }

            public void sendMessage(UUID s1, @NotNull String message) {
                if (sender.isLog()) {
                    finalS.sendMessage(s1, message);
                }
            }

            public void sendMessage(UUID s1, String ... messages) {
                if (sender.isLog()) {
                    finalS.sendMessage(s1, messages);
                }
            }

            @NotNull
            public Server getServer() {
                return finalS.getServer();
            }

            @NotNull
            public String getName() {
                return finalS.getName();
            }

            @NotNull
            public CommandSender.Spigot spigot() {
                return finalS.spigot();
            }

            public boolean isPermissionSet(@NotNull String name) {
                return finalS.isPermissionSet(name);
            }

            public boolean isPermissionSet(@NotNull Permission perm) {
                return finalS.isPermissionSet(perm);
            }

            public boolean hasPermission(@NotNull String name) {
                return finalS.hasPermission(name);
            }

            public boolean hasPermission(@NotNull Permission perm) {
                return finalS.hasPermission(perm);
            }

            @NotNull
            public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String name, boolean value) {
                return finalS.addAttachment(plugin, name, value);
            }

            @NotNull
            public PermissionAttachment addAttachment(@NotNull Plugin plugin) {
                return finalS.addAttachment(plugin);
            }

            public PermissionAttachment addAttachment(@NotNull Plugin plugin, @NotNull String name, boolean value, int ticks) {
                return finalS.addAttachment(plugin, name, value, ticks);
            }

            public PermissionAttachment addAttachment(@NotNull Plugin plugin, int ticks) {
                return finalS.addAttachment(plugin, ticks);
            }

            public void removeAttachment(@NotNull PermissionAttachment attachment) {
                finalS.removeAttachment(attachment);
            }

            public void recalculatePermissions() {
                finalS.recalculatePermissions();
            }

            @NotNull
            public Set<PermissionAttachmentInfo> getEffectivePermissions() {
                return finalS.getEffectivePermissions();
            }

            public boolean isOp() {
                return finalS.isOp();
            }

            public void setOp(boolean value) {
                finalS.setOp(value);
            }
        };
    }
}

