/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.recipes;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.items.CustomItem;
import me.ikevoodoo.smpcore.recipes.RecipeData;
import me.ikevoodoo.smpcore.recipes.RecipeOptions;
import me.ikevoodoo.smpcore.recipes.RecipeReplacement;
import me.ikevoodoo.smpcore.utils.StringUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class RecipeLoader {
    private static final String[] MATERIAL_NAMES = StringUtils.toStringArray(Material.values());
    private final SMPPlugin plugin;

    public RecipeLoader(SMPPlugin plugin) {
        this.plugin = plugin;
    }

    private String closestMaterial(String name) {
        return StringUtils.getClosest(name, MATERIAL_NAMES);
    }

    private String fix(String mat) {
        return this.closestMaterial(StringUtils.toEnumCompatible(mat));
    }

    private String toReadable(Material mat) {
        return mat.toString().toLowerCase(Locale.ROOT).replaceAll("([a-zA-Z0-9])_", "$1 ").replaceAll("-+", "_").replace("minecraft:", "").replace(":", "");
    }

    private String toReadable(RecipeChoice choice) {
        RecipeChoice recipeChoice = choice;
        if (recipeChoice instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice exact = (RecipeChoice.ExactChoice)recipeChoice;
            return this.toReadable(exact.getItemStack().getType());
        }
        recipeChoice = choice;
        if (recipeChoice instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice mat = (RecipeChoice.MaterialChoice)recipeChoice;
            return this.toReadable((Material)mat.getChoices().get(0));
        }
        return "CONVERSION_ERROR";
    }

    private Material fromString(String mat) {
        return Material.getMaterial((String)this.fix(mat));
    }

    private RecipeChoice[] getChoices(ConfigurationSection config, String path) {
        RecipeChoice[] choices = (RecipeChoice[])Arrays.stream(new RecipeChoice[9]).map(m -> new RecipeChoice.MaterialChoice(Material.AIR)).toArray(RecipeChoice[]::new);
        if (!config.isConfigurationSection(path)) {
            return choices;
        }
        ConfigurationSection section = config.getConfigurationSection(path);
        if (section == null) {
            return choices;
        }
        for (String key : section.getKeys(false)) {
            Material mat = Material.AIR;
            String matName = config.getString(path + "." + key + ".item");
            if (matName == null) continue;
            String name = StringUtils.toEnumCompatible(matName);
            int index = Integer.parseInt(key);
            Optional<CustomItem> itemOptional = this.plugin.getItem(name.toLowerCase(Locale.ROOT));
            if (itemOptional.isPresent()) {
                CustomItem item = itemOptional.get();
                ItemStack stack = item.getItemStack();
                if (stack == null) continue;
                if (index > 0 && index <= choices.length) {
                    choices[index - 1] = new RecipeChoice.ExactChoice(stack);
                    continue;
                }
                choices[Math.min((int)index, (int)(choices.length - 1))] = new RecipeChoice.ExactChoice(stack);
                continue;
            }
            try {
                mat = Material.valueOf((String)this.fix(name));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Invalid material: {0}", matName);
            }
            if (index > 0 && index <= choices.length) {
                choices[index - 1] = new RecipeChoice.MaterialChoice(mat);
                continue;
            }
            choices[Math.min((int)index, (int)(choices.length - 1))] = new RecipeChoice.MaterialChoice(mat);
        }
        for (int i = 0; i < choices.length; ++i) {
            config.set(path + "." + (i + 1) + ".item", (Object)this.toReadable(choices[i]));
        }
        return choices;
    }

    public Material[] getMats(RecipeChoice[] choices) {
        return (Material[])Arrays.stream(choices).map(choice -> {
            RecipeChoice exact$temp = choice;
            if (exact$temp instanceof RecipeChoice.ExactChoice) {
                RecipeChoice.ExactChoice exact = (RecipeChoice.ExactChoice)exact$temp;
                return exact.getItemStack().getType();
            }
            RecipeChoice mat$temp = choice;
            if (mat$temp instanceof RecipeChoice.MaterialChoice) {
                RecipeChoice.MaterialChoice mat = (RecipeChoice.MaterialChoice)mat$temp;
                return (Material)mat.getChoices().get(0);
            }
            return Material.AIR;
        }).toArray(Material[]::new);
    }

    public RecipeData getRecipe(ConfigurationSection config, String path, ItemStack output, NamespacedKey key, boolean shaped) {
        RecipeChoice[] choices = this.getChoices(config, path);
        if (shaped) {
            ShapedRecipe recipe = new ShapedRecipe(key, output);
            recipe.shape(new String[]{"012", "345", "678"});
            for (int i = 0; i < choices.length; ++i) {
                recipe.setIngredient(("" + i).charAt(0), choices[i]);
            }
            return new RecipeData((Recipe)recipe, this.getMats(choices), choices);
        }
        ShapelessRecipe recipe = new ShapelessRecipe(key, output);
        for (RecipeChoice choice : choices) {
            recipe.addIngredient(choice);
        }
        return new RecipeData((Recipe)recipe, this.getMats(choices), choices);
    }

    public RecipeData getRecipe(String path, ItemStack output, NamespacedKey key, boolean shaped) {
        return this.getRecipe((ConfigurationSection)this.plugin.getConfig(), path, output, key, shaped);
    }

    public RecipeData getRecipe(ConfigurationSection config, String path, ItemStack output, NamespacedKey key, RecipeOptions options) {
        return this.getRecipe(config, path, output, key, options.shaped());
    }

    public RecipeOptions getOptions(ConfigurationSection config) {
        if (config == null) {
            return null;
        }
        return new RecipeOptions(this.fromString(config.getString("type")), config.getInt("outputAmount"), config.getBoolean("shaped"));
    }

    public RecipeOptions getOptions(String path) {
        return this.getOptions(this.plugin.getConfig().getConfigurationSection(path));
    }

    public void writeRecipe(File file, RecipeData recipe, RecipeReplacement ... replacements) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        RecipeChoice[] choices = recipe.choices();
        for (int i = 0; i < choices.length; ++i) {
            String key = String.valueOf(i + 1);
            Optional<Object> replacement = this.getReplacement(key, replacements);
            config.set("recipe." + key + ".item", replacement.orElse(this.toReadable(choices[i])));
        }
        config.set("options.type", (Object)this.toReadable(recipe.recipe().getResult().getType()));
        config.set("options.shaped", (Object)(recipe.recipe() instanceof ShapedRecipe));
        config.set("options.outputAmount", (Object)recipe.recipe().getResult().getAmount());
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Optional<Object> getReplacement(String key, RecipeReplacement ... replacements) {
        for (RecipeReplacement replacement : replacements) {
            if (!replacement.key().equals(key)) continue;
            return Optional.ofNullable(replacement.value());
        }
        return Optional.empty();
    }
}

