/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.menus.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import me.ikevoodoo.smpcore.menus.v2.PagedMenu;
import me.ikevoodoo.smpcore.menus.v2.widgets.Widget;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public abstract class Page {
    private final List<BiFunction<Inventory, Player, Widget>> widgetSuppliers = new ArrayList<BiFunction<Inventory, Player, Widget>>();
    private final int index;
    private final int width;
    private final int height;
    private final PagedMenu menu;

    protected Page(int index, int width, int height, PagedMenu menu) {
        this.index = index;
        this.width = width;
        this.height = height;
        this.menu = menu;
    }

    public final void update(Inventory inventory, Player player) {
        this.draw(inventory, player);
        for (BiFunction<Inventory, Player, Widget> widgetSupplier : this.widgetSuppliers) {
            Widget widget = widgetSupplier.apply(inventory, player);
            if (widget == null || !widget.canDisplay()) continue;
            widget.draw(inventory, player);
        }
    }

    protected abstract void draw(Inventory var1, Player var2);

    protected final void setBackground(Material background) {
    }

    protected final void addWidgetWhen(Widget widget, BiPredicate<Inventory, Player> predicate) {
        this.widgetSuppliers.add((inv, player) -> {
            if (predicate.test((Inventory)inv, (Player)player)) {
                return widget;
            }
            return null;
        });
    }

    protected final void addWidget(Widget widget) {
        this.addWidgetWhen(widget, (inv, player) -> true);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isFirst() {
        return this.getIndex() == 0;
    }

    public boolean isLast() {
        return this.getIndex() == this.getMenu().getPageCount();
    }

    public PagedMenu getMenu() {
        return this.menu;
    }
}

