/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.menus.MenuHolder;
import me.ikevoodoo.smpcore.menus.MenuPage;
import me.ikevoodoo.smpcore.menus.PageData;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;

public class Menu
extends MenuHolder {
    private final List<MenuPage> pages = new ArrayList<MenuPage>();
    private final HashMap<UUID, Integer> viewingPage = new HashMap();
    private final HashMap<UUID, Integer> lastPages = new HashMap();
    private final NamespacedKey id;
    private final List<Consumer<Player>> openListeners = new ArrayList<Consumer<Player>>();

    public Menu(SMPPlugin plugin, String id) {
        super(plugin);
        this.id = this.makeKey(id);
    }

    public Menu(SMPPlugin plugin, NamespacedKey id) {
        super(plugin);
        this.id = id;
    }

    public NamespacedKey id() {
        return this.id;
    }

    public boolean is(NamespacedKey id) {
        return this.id.equals((Object)id);
    }

    public boolean is(String id) {
        return this.is(this.getPlugin().makeKey(id));
    }

    public boolean isViewer(Player player) {
        return this.viewingPage.containsKey(player.getUniqueId());
    }

    public MenuPage page(PageData data) {
        MenuPage page = new MenuPage(data, this);
        this.pages.add(page);
        return page;
    }

    public Optional<MenuPage> page(int page) {
        if (this.pages.isEmpty() || page >= this.pages.size() || page < 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.pages.get(page));
    }

    public Optional<MenuPage> page(Player player) {
        return this.page(this.viewingPage.get(player.getUniqueId()));
    }

    public void open(Player player) {
        if (this.pages.isEmpty()) {
            return;
        }
        this.closePage(player);
        MenuPage first = this.pages.get(0);
        first.open(player);
        this.openListeners.forEach(listener -> listener.accept(player));
        this.viewingPage.put(player.getUniqueId(), 0);
    }

    public void openLast(Player player) {
        if (this.pages.isEmpty()) {
            return;
        }
        this.closePage(player);
        int page = this.lastPages.getOrDefault(player.getUniqueId(), 0);
        MenuPage first = this.pages.get(page);
        first.open(player);
        this.openListeners.forEach(listener -> listener.accept(player));
        this.viewingPage.put(player.getUniqueId(), page);
    }

    public void next(Player player) {
        this.move(player, 1);
    }

    public void previous(Player player) {
        this.move(player, -1);
    }

    public void set(Player player, int page) {
        if (this.pages.isEmpty() || page >= this.pages.size() || page < 0) {
            return;
        }
        this.closePage(player);
        this.viewingPage.put(player.getUniqueId(), page);
        this.lastPages.put(player.getUniqueId(), page);
        MenuPage menu = this.pages.get(page);
        menu.open(player);
    }

    public void close(Player player) {
        this.closePage(player);
        player.closeInventory();
    }

    public void onOpen(Consumer<Player> listener) {
        this.openListeners.add(listener);
    }

    private void move(Player player, int amount) {
        if (this.pages.isEmpty()) {
            return;
        }
        Integer page = this.viewingPage.get(player.getUniqueId());
        if (page == null) {
            return;
        }
        if ((page = Integer.valueOf(page + amount)) >= this.pages.size() || page < 0) {
            return;
        }
        this.closePage(player);
        MenuPage menu = this.pages.get(page);
        menu.open(player);
        this.viewingPage.put(player.getUniqueId(), page);
        this.lastPages.put(player.getUniqueId(), page);
    }

    private void closePage(Player player) {
        Integer page = this.viewingPage.get(player.getUniqueId());
        if (page == null) {
            return;
        }
        MenuPage menu = this.pages.get(page);
        menu.close(player);
        this.viewingPage.remove(player.getUniqueId());
    }
}

