/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.listeners;

import java.util.Optional;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.items.CustomItem;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.inventory.ItemStack;

public class ItemDamageListener
implements Listener {
    private final SMPPlugin plugin;

    public ItemDamageListener(SMPPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Entity entity = event.getEntity();
        Entity entity2 = entity;
        if (!(entity2 instanceof Item)) {
            return;
        }
        Item item = (Item)entity2;
        ItemStack itemStack = item.getItemStack();
        Optional<CustomItem> customItem = this.plugin.getItem(itemStack);
        if (customItem.isPresent() && !customItem.get().shouldAllowCombustion()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamageByBlock(EntityDamageByBlockEvent event) {
        boolean shouldCancel;
        Entity entity = event.getEntity();
        Entity entity2 = entity;
        if (!(entity2 instanceof Item)) {
            return;
        }
        Item item = (Item)entity2;
        Block block = event.getDamager();
        if (block == null) {
            return;
        }
        ItemStack itemStack = item.getItemStack();
        Optional<CustomItem> customItem = this.plugin.getItem(itemStack);
        if (customItem.isEmpty()) {
            return;
        }
        switch (block.getType()) {
            case CACTUS: {
                boolean bl;
                if (!customItem.get().shouldAllowCactusDamage()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case FIRE: 
            case LAVA: {
                boolean bl;
                if (!customItem.get().shouldAllowCombustion()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = shouldCancel = false;
            }
        }
        if (shouldCancel) {
            event.setCancelled(true);
        }
    }
}

