/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.items;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.callbacks.items.PlayerUseItemCallback;
import me.ikevoodoo.smpcore.functions.SerializableConsumer;
import me.ikevoodoo.smpcore.items.ItemClickResult;
import me.ikevoodoo.smpcore.items.ItemClickState;
import me.ikevoodoo.smpcore.recipes.RecipeData;
import me.ikevoodoo.smpcore.recipes.RecipeOptions;
import me.ikevoodoo.smpcore.text.messaging.Message;
import me.ikevoodoo.smpcore.utils.Pair;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class CustomItem {
    private final List<NamespacedKey> keys = new ArrayList<NamespacedKey>();
    private boolean decreaseOnUse = false;
    private boolean allowCombustion = true;
    private boolean allowCactusDamage = true;
    private final CustomItemData data = new CustomItemData();
    private Pair<NamespacedKey, Recipe> recipe;
    private RecipeData recipeData;
    private final String id;
    private final Message friendlyName;
    private SerializableConsumer<Player> unlockOnJoin;
    private Consumer<Player> unlockOnObtain;
    private Supplier<RecipeOptions> optionsSupplier = () -> new RecipeOptions(Material.STONE, 1, true);
    private final SMPPlugin plugin;
    private boolean enabled = true;
    private File recipeFIle;

    protected CustomItem(SMPPlugin plugin, String id, Message friendlyName) {
        this.plugin = plugin;
        this.id = id;
        this.friendlyName = friendlyName;
    }

    public final String getId() {
        return this.id;
    }

    public final Message getFriendlyName() {
        return this.friendlyName;
    }

    public static void give(Player player, CustomItem customItem) {
        player.getInventory().addItem(new ItemStack[]{customItem.getItemStack()});
    }

    public static void remove(Player player, CustomItem customItem, int amount) {
        ItemStack item = customItem.getItemStack(amount);
        player.getInventory().removeItem(new ItemStack[]{item});
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final CustomItem setRecipeFile(File recipeFIle) {
        this.recipeFIle = recipeFIle;
        return this;
    }

    public final CustomItem setRecipeFile(String name) {
        this.recipeFIle = this.getPlugin().getConfigHandler().getFile(name);
        return this;
    }

    public final File getRecipeFile() {
        return this.recipeFIle;
    }

    public final boolean hasRecipeFile() {
        return this.recipeFIle != null;
    }

    public final ItemStack getItemStack() {
        int customModelData;
        List<String> lore;
        ItemStack itemStack = this.createItem(null);
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        assert (itemMeta != null);
        PersistentDataContainer container = itemMeta.getPersistentDataContainer();
        for (NamespacedKey key : this.keys) {
            container.set(key, PersistentDataType.INTEGER, (Object)0);
        }
        container.set(this.makeKey(this.getId()), PersistentDataType.BYTE, (Object)0);
        String displayName = this.data.displayName.get();
        if (displayName != null && !displayName.isBlank()) {
            itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
        }
        if ((lore = this.data.lore.get()) != null && !lore.isEmpty()) {
            lore.replaceAll(textToTranslate -> ChatColor.translateAlternateColorCodes((char)'&', (String)textToTranslate));
            itemMeta.setLore(lore);
        }
        if ((customModelData = this.data.customModelData.getAsInt()) != -1) {
            itemMeta.setCustomModelData(Integer.valueOf(customModelData));
        }
        itemStack.setItemMeta(itemMeta);
        itemStack.setAmount(this.getRecipeOptions().amount());
        return itemStack;
    }

    public final ItemStack getItemStack(int amount) {
        ItemStack itemStack = this.getItemStack();
        if (itemStack == null) {
            return null;
        }
        itemStack.setAmount(amount);
        return itemStack;
    }

    public final ItemStack getCleanStack() {
        ItemStack stack = this.getItemStack();
        if (stack == null) {
            return null;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.remove(this.makeKey(this.getId()));
        stack.setItemMeta(meta);
        return stack;
    }

    public final ItemStack getCleanStack(int amount) {
        ItemStack itemStack = this.getCleanStack();
        if (itemStack == null) {
            return null;
        }
        itemStack.setAmount(amount);
        return itemStack;
    }

    public final RecipeOptions getRecipeOptions() {
        return this.optionsSupplier.get();
    }

    public final RecipeData getRecipeData() {
        return this.recipeData;
    }

    public final CustomItem unlockOnJoin() {
        this.clearConsumers();
        this.unlockOnJoin = this.plugin.getJoinActionHandler().runAlwaysOnJoin(player -> {
            NamespacedKey key;
            NamespacedKey namespacedKey = key = this.recipe == null ? null : this.recipe.getFirst();
            if (key == null) {
                return;
            }
            player.discoverRecipe(key);
        });
        return this;
    }

    public final CustomItem unlockOnObtain(Material ... materials) {
        this.clearConsumers();
        this.unlockOnObtain = this.plugin.getInventoryActionHandler().onInventoryAction(player -> {
            NamespacedKey key;
            PlayerInventory inventory = player.getInventory();
            for (Material material : materials) {
                if (inventory.contains(material)) continue;
                return;
            }
            NamespacedKey namespacedKey = key = this.recipe == null ? null : this.recipe.getFirst();
            if (key == null) {
                return;
            }
            player.discoverRecipe(key);
        });
        return this;
    }

    public final boolean containsAtLeast(Player player, int amount) {
        return player.getInventory().containsAtLeast(this.getItemStack(), amount);
    }

    public final void remove(Player player, int amount) {
        player.getInventory().removeItem(new ItemStack[]{this.getItemStack(amount)});
    }

    public final CustomItem addKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, key);
        this.keys.add(namespacedKey);
        this.plugin.onUse(key, new PlayerUseItemCallback(){

            @Override
            public boolean useItem(Player player, ItemStack item, Action action) {
                ItemClickResult result = CustomItem.this.tryClick(player, item, action);
                if (result == null) {
                    return true;
                }
                if (CustomItem.this.decreaseOnUse && result.state() == ItemClickState.SUCCESS) {
                    item.setAmount(item.getAmount() - 1);
                }
                return result.cancel();
            }

            @Override
            public List<Action> allowedActions() {
                return List.of(Action.RIGHT_CLICK_AIR, Action.RIGHT_CLICK_BLOCK);
            }
        });
        return this;
    }

    public final CustomItem setDecreaseOnUse(boolean decreaseOnUse) {
        this.decreaseOnUse = decreaseOnUse;
        return this;
    }

    public final CustomItem setAllowCombustion(boolean allowCombustion) {
        this.allowCombustion = allowCombustion;
        return this;
    }

    public final CustomItem setAllowCactusDamage(boolean allowCactusDamage) {
        this.allowCactusDamage = allowCactusDamage;
        return this;
    }

    public final boolean shouldAllowCombustion() {
        return this.allowCombustion;
    }

    public final boolean shouldAllowCactusDamage() {
        return this.allowCactusDamage;
    }

    public abstract ItemStack createItem(Player var1);

    public final ItemClickResult tryClick(Player player, ItemStack itemStack, Action action) {
        try {
            if (this.enabled) {
                return this.onClick(player, itemStack, action);
            }
            return new ItemClickResult(ItemClickState.IGNORE, true);
        }
        catch (Exception e) {
            return new ItemClickResult(ItemClickState.FAIL, true);
        }
    }

    protected ItemClickResult onClick(Player player, ItemStack itemStack, Action action) {
        return new ItemClickResult(ItemClickState.SUCCESS, true);
    }

    public boolean onDrop(Player player, ItemStack itemStack) {
        return false;
    }

    public Pair<NamespacedKey, Recipe> createRecipe() {
        return null;
    }

    public RecipeData createRecipeData() {
        if (!this.hasRecipeFile()) {
            return null;
        }
        return this.getPlugin().getRecipeLoader().getRecipe((ConfigurationSection)this.getPlugin().getConfigHandler().getYmlConfig(this.getRecipeFile().getName()), "recipe", this.getItemStack(), this.makeKey(this.getId() + "_recipe"), this.getRecipeOptions());
    }

    public final void reload() {
        NamespacedKey old = this.recipe != null ? this.recipe.getFirst() : null;
        this.recipeData = this.createRecipeData();
        Pair<NamespacedKey, Recipe> newRecipe = this.createRecipe();
        if (old != null && Bukkit.getRecipe((NamespacedKey)old) != null) {
            Bukkit.removeRecipe((NamespacedKey)old);
        }
        if (newRecipe != null && this.enabled) {
            Bukkit.addRecipe((Recipe)newRecipe.getSecond());
        }
        this.recipe = newRecipe;
    }

    public final CustomItem setDisplayName(Supplier<String> displayName) {
        if (displayName != null) {
            this.data.displayName = displayName;
        }
        return this;
    }

    public final CustomItem setLore(Supplier<List<String>> lore) {
        if (lore != null) {
            this.data.lore = lore;
        }
        return this;
    }

    public final CustomItem setCustomModelData(IntSupplier customModelData) {
        if (customModelData != null) {
            this.data.customModelData = customModelData;
        }
        return this;
    }

    public final CustomItem setOptions(Supplier<RecipeOptions> options) {
        if (options != null) {
            this.optionsSupplier = options;
        }
        return this;
    }

    public final CustomItem bindConfig(String path) {
        return this.setDisplayName(() -> this.getConfig().getString(path + ".displayName", this.getConfig().getString(path + ".name", null))).setLore(() -> this.getConfig().getStringList(path + ".lore")).setCustomModelData(() -> this.getConfig().getInt(path + ".customModelData", -1));
    }

    public final CustomItem bindConfigOptions(String config, String path) {
        this.optionsSupplier = () -> this.plugin.getRecipeLoader().getOptions(this.plugin.getConfigHandler().getYmlConfig(config).getConfigurationSection(path));
        return this;
    }

    public final CustomItem bindConfig(String path, String key) {
        return this.bindConfig(path + "." + key);
    }

    public final CustomItem bindConfig(ConfigurationSection section) {
        return this.bindConfig(section.getCurrentPath());
    }

    public final CustomItem bindConfig(ConfigurationSection section, String key) {
        return this.bindConfig(section.getCurrentPath(), key);
    }

    public final FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    public final NamespacedKey makeKey(String key) {
        return new NamespacedKey((Plugin)this.plugin, key);
    }

    public final SMPPlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return String.format("Item '%s'", this.getId());
    }

    private void clearConsumers() {
        if (this.unlockOnJoin != null) {
            this.plugin.getJoinActionHandler().cancelAlwaysOnJoin(this.unlockOnJoin);
        }
        if (this.unlockOnObtain != null) {
            this.plugin.getInventoryActionHandler().removeInventoryAction(this.unlockOnObtain);
        }
        this.unlockOnJoin = null;
        this.unlockOnObtain = null;
    }

    private static class CustomItemData {
        private Supplier<String> displayName = () -> null;
        private Supplier<List<String>> lore = () -> null;
        private IntSupplier customModelData = () -> -1;

        private CustomItemData() {
        }
    }
}

