/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.shared.PluginProvider;
import me.ikevoodoo.smpcore.texture.ResourcePackData;
import me.ikevoodoo.smpcore.utils.FileUtils;
import me.ikevoodoo.smpcore.utils.HashUtils;
import me.ikevoodoo.smpcore.utils.URLUtils;
import org.bukkit.entity.Player;

public class ResourcePackHandler
extends PluginProvider {
    private final HashMap<String, ResourcePackData> resourcePacks = new HashMap();
    private final HashMap<String, ResourcePackData> resourcePackFiles = new HashMap();

    public ResourcePackHandler(SMPPlugin plugin) {
        super(plugin);
    }

    public void addResourcePack(String id, String location) {
        byte[] hash = URLUtils.ifValid(location, conn -> HashUtils.sha1Hash(conn.getInputStream()));
        if (hash == null) {
            return;
        }
        this.resourcePacks.put(id, new ResourcePackData(location, hash));
    }

    public void adResourcePackFile(String id, File file) throws IOException, NoSuchAlgorithmException {
        if (!file.exists()) {
            return;
        }
        this.getPlugin().getCacheFolder().mkdirs();
        File cacheFile = new File(this.getPlugin().getCacheFolder(), FileUtils.getName(file) + ".zip");
        if (cacheFile.exists()) {
            Files.deleteIfExists(cacheFile.toPath());
            cacheFile.createNewFile();
        }
        try (ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(cacheFile.toPath(), new OpenOption[0]));){
            FileUtils.addToZip(file, zip);
        }
        this.resourcePackFiles.put(id, new ResourcePackData(cacheFile.getPath(), HashUtils.sha1Hash(Files.newInputStream(cacheFile.toPath(), new OpenOption[0]))));
    }

    public void applyResourcePack(Player player, String id) {
        ResourcePackData data = this.resourcePacks.get(id);
        if (data == null) {
            this.applyResourcePackFile(player, id);
            return;
        }
        player.setResourcePack(data.location(), data.hash());
    }

    public void applyResourcePackFile(Player player, String id) {
        ResourcePackData data = this.resourcePackFiles.get(id);
        if (data == null) {
            return;
        }
        player.setResourcePack(this.getPlugin().getServerIp() + ":8989/" + data.location(), data.hash());
    }

    public void removeResourcePack(String id) {
        this.resourcePacks.remove(id);
    }

    public void reload() throws IOException, NoSuchAlgorithmException {
        HashMap<String, ResourcePackData> newResourcePacks = new HashMap<String, ResourcePackData>(this.resourcePacks);
        this.resourcePacks.clear();
        for (Map.Entry<String, ResourcePackData> entry : newResourcePacks.entrySet()) {
            this.addResourcePack(entry.getKey(), entry.getValue().location());
        }
    }
}

