/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.functions.SerializableConsumer;
import me.ikevoodoo.smpcore.shared.PluginProvider;
import org.bukkit.entity.Player;

public class JoinActionHandler
extends PluginProvider {
    private final HashMap<UUID, List<SerializableConsumer<UUID>>> joinActions = new HashMap();
    private final List<SerializableConsumer<Player>> joinListeners = new ArrayList<SerializableConsumer<Player>>();

    public JoinActionHandler(SMPPlugin plugin) {
        super(plugin);
    }

    public void runOnJoin(UUID id, SerializableConsumer<UUID> runnable) {
        if (this.joinActions.containsKey(id)) {
            this.joinActions.get(id).add(runnable);
        } else {
            this.joinActions.put(id, new ArrayList<SerializableConsumer<UUID>>(List.of(runnable)));
        }
    }

    public SerializableConsumer<Player> runAlwaysOnJoin(SerializableConsumer<Player> runnable) {
        this.joinListeners.add(runnable);
        return runnable;
    }

    public void cancelAlwaysOnJoin(SerializableConsumer<Player> runnable) {
        this.joinListeners.remove(runnable);
    }

    public void fire(UUID id) {
        if (this.joinActions.containsKey(id)) {
            this.joinActions.remove(id).forEach(uuidConsumer -> uuidConsumer.accept(id));
        }
    }

    public void fire(Player player) {
        this.joinListeners.forEach(consumer -> consumer.accept(player));
    }

    public HashMap<UUID, List<SerializableConsumer<UUID>>> getJoinActions() {
        return this.joinActions;
    }

    public List<SerializableConsumer<Player>> getJoinListeners() {
        return this.joinListeners;
    }
}

