/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.caching.FastUUIDCache;
import me.ikevoodoo.smpcore.callbacks.eliminations.EliminationCallback;
import me.ikevoodoo.smpcore.callbacks.eliminations.EliminationType;
import me.ikevoodoo.smpcore.handlers.EliminationData;
import me.ikevoodoo.smpcore.shared.PluginProvider;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public final class EliminationHandler
extends PluginProvider {
    private final NamespacedKey eliminationKey;
    private final NamespacedKey bannedAtKey;
    private final NamespacedKey bannedMessageKey;
    private final List<EliminationCallback> eliminationCallbacks = new ArrayList<EliminationCallback>();
    private final List<EliminationCallback> reviveCallbacks = new ArrayList<EliminationCallback>();
    private final List<BiConsumer<UUID, Number>> cacheListeners = new ArrayList<BiConsumer<UUID, Number>>();
    private final FastUUIDCache cache = new FastUUIDCache();

    public EliminationHandler(SMPPlugin plugin) {
        super(plugin);
        this.eliminationKey = this.makeKey("eliminated_player");
        this.bannedAtKey = this.makeKey("eliminated_at");
        this.bannedMessageKey = this.makeKey("eliminated_message");
    }

    public void save(File file) throws IOException {
        try (OutputStream stream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            this.cache.save(stream);
        }
    }

    public void load(File file) throws IOException {
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            this.cache.load(stream);
        }
    }

    public Map<UUID, Number> getEliminatedPlayers() {
        return this.cache.fetch();
    }

    public void eliminate(Player player) {
        this.eliminate(player, EliminationData.infiniteTime());
    }

    public void eliminate(UUID id) {
        Player player = Bukkit.getPlayer((UUID)id);
        if (player != null) {
            this.eliminate(player);
        }
    }

    public void eliminate(UUID id, EliminationData eliminationData) {
        Player player = Bukkit.getPlayer((UUID)id);
        if (player != null) {
            this.eliminate(player, eliminationData);
        }
    }

    public void markEliminated(UUID id, EliminationData eliminationData) {
        this.addToCache(id, eliminationData.getCacheTime());
    }

    public void eliminate(Player player, EliminationData eliminationData) {
        if (this.isEliminated(player)) {
            return;
        }
        this.markEliminated(player.getUniqueId(), eliminationData);
        PersistentDataContainer container = player.getPersistentDataContainer();
        container.set(this.eliminationKey, PersistentDataType.LONG, (Object)eliminationData.banTime());
        container.set(this.bannedAtKey, PersistentDataType.LONG, (Object)System.currentTimeMillis());
        container.set(this.bannedMessageKey, PersistentDataType.STRING, (Object)eliminationData.message());
        this.eliminationCallbacks.forEach(callback -> callback.whenTriggered(EliminationType.ELIMINATED, player));
    }

    public boolean isEliminated(Player player) {
        PersistentDataContainer container = player.getPersistentDataContainer();
        return container.has(this.eliminationKey, PersistentDataType.LONG);
    }

    public boolean isEliminated(UUID id) {
        Player player = Bukkit.getPlayer((UUID)id);
        if (player != null) {
            return this.isEliminated(player);
        }
        return this.cache.has(id);
    }

    public long getBanTime(Player player) {
        PersistentDataContainer container = player.getPersistentDataContainer();
        Long value = (Long)container.get(this.eliminationKey, PersistentDataType.LONG);
        return value == null ? 0L : value;
    }

    public long getBannedAt(Player player) {
        PersistentDataContainer container = player.getPersistentDataContainer();
        Long value = (Long)container.get(this.bannedAtKey, PersistentDataType.LONG);
        return value == null ? 0L : value;
    }

    public String getBanMessage(Player player) {
        PersistentDataContainer container = player.getPersistentDataContainer();
        String value = (String)container.get(this.bannedMessageKey, PersistentDataType.STRING);
        return value == null ? "\u00a7cYou have been eliminated." : value;
    }

    public EliminationData getEliminationData(Player player) {
        return new EliminationData(this.getBanMessage(player), this.getBanTime(player));
    }

    public void revive(Player player) {
        if (!this.isEliminated(player)) {
            return;
        }
        this.removeFromCache(player.getUniqueId());
        PersistentDataContainer container = player.getPersistentDataContainer();
        container.remove(this.eliminationKey);
        container.remove(this.bannedAtKey);
        this.reviveCallbacks.forEach(callback -> callback.whenTriggered(EliminationType.REVIVED, player));
    }

    public void revive(UUID id) {
        Player player = Bukkit.getPlayer((UUID)id);
        if (player != null) {
            this.revive(player);
        }
    }

    public void reviveAll() {
        Bukkit.getOnlinePlayers().forEach(this::revive);
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            this.reviveOffline(offlinePlayer);
        }
    }

    public void eliminateAll() {
        this.eliminateAll(EliminationData.infiniteTime());
    }

    public void eliminateAll(EliminationData eliminationData) {
        ArrayList excluded = new ArrayList();
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (!excluded.contains(player.getUniqueId())) {
                excluded.add(player.getUniqueId());
                this.eliminate((Player)player, eliminationData);
            }
        });
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            if (excluded.contains(offlinePlayer.getUniqueId())) continue;
            this.eliminateOffline(offlinePlayer, eliminationData);
        }
    }

    public void listen(EliminationType type, EliminationCallback callback) {
        if (type == EliminationType.ELIMINATED) {
            this.eliminationCallbacks.add(callback);
            return;
        }
        this.reviveCallbacks.add(callback);
    }

    public void onCacheUpdated(BiConsumer<UUID, Number> listener) {
        this.cacheListeners.add(listener);
    }

    public void reviveOffline(OfflinePlayer player) {
        if (player == null) {
            return;
        }
        if (player.isOnline()) {
            this.revive(player.getPlayer());
        } else {
            this.getPlugin().getJoinActionHandler().runOnJoin(player.getUniqueId(), this::revive);
            this.removeFromCache(player.getUniqueId());
        }
    }

    public void eliminateOffline(OfflinePlayer player) {
        this.eliminateOffline(player, EliminationData.infiniteTime());
    }

    public void eliminateOffline(OfflinePlayer player, EliminationData eliminationData) {
        if (player == null) {
            return;
        }
        if (player.isOnline()) {
            this.eliminate(player.getUniqueId(), eliminationData);
        } else {
            this.getPlugin().getJoinActionHandler().runOnJoin(player.getUniqueId(), id -> this.eliminate((UUID)id, eliminationData));
            this.markEliminated(player.getUniqueId(), eliminationData);
        }
    }

    private void removeFromCache(UUID id) {
        this.cache.remove(id);
        this.cacheListeners.forEach(listener -> listener.accept(id, null));
    }

    private void addToCache(UUID id, Number value) {
        this.cache.add(id, value);
        this.cacheListeners.forEach(listener -> listener.accept(id, value));
    }
}

