/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.config;

import java.io.File;
import java.util.HashMap;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.config.ConfigData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigHandler {
    private final HashMap<String, ConfigData> configs = new HashMap();
    private final HashMap<String, YamlConfiguration> yamlConfigs = new HashMap();
    private final SMPPlugin plugin;

    public ConfigHandler(SMPPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerConfig(ConfigData config) {
        this.configs.put(config.getName(), config);
    }

    public ConfigData getConfig(String name) {
        return this.configs.get(name);
    }

    public boolean exists(String name) {
        return this.configs.containsKey(name) && new File(this.plugin.getDataFolder(), name).exists();
    }

    public FileConfiguration getYmlConfig(String name) {
        ConfigData config = this.getConfig(name);
        if (config == null) {
            return (FileConfiguration)this.yamlConfigs.computeIfAbsent(name, s -> YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), name)));
        }
        return config.getConfig();
    }

    public File getFile(String name) {
        return new File(this.plugin.getDataFolder(), name);
    }

    public void reload() {
        for (ConfigData config : this.configs.values()) {
            config.reload();
        }
        this.yamlConfigs.clear();
    }
}

