/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.smpcore.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.commands.CommandUsable;
import me.ikevoodoo.smpcore.commands.Context;
import me.ikevoodoo.smpcore.commands.arguments.Argument;
import me.ikevoodoo.smpcore.commands.arguments.ArgumentWrapper;
import me.ikevoodoo.smpcore.commands.arguments.Arguments;
import me.ikevoodoo.smpcore.commands.arguments.OptionalFor;
import me.ikevoodoo.smpcore.shared.PluginProvider;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public abstract class SMPCommand
extends PluginProvider
implements CommandExecutor,
TabCompleter {
    private final HashMap<String, SMPCommand> subCommands;
    private SMPCommand parent;
    private final String name;
    private final HashMap<UUID, Long> cooldowns;
    private String permission;
    private CommandUsable usable = CommandUsable.ALL;
    private List<ArgumentWrapper> args = new ArrayList<ArgumentWrapper>();

    public SMPCommand(SMPPlugin plugin, String name, String permission) {
        super(plugin);
        this.name = name;
        this.permission = permission;
        this.subCommands = new HashMap();
        this.cooldowns = new HashMap();
    }

    public SMPCommand(SMPPlugin plugin, String name) {
        this(plugin, name, null);
    }

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String successMessage;
        if (this.permission != null && !this.permission.isBlank() && !sender.hasPermission(this.permission)) {
            sender.sendMessage(this.getNoPermissionMessage(sender));
            return true;
        }
        Arguments arguments = new Arguments(sender, args);
        if (!arguments.match(this.args)) {
            SMPCommand subCommand;
            if (args.length > 0 && (subCommand = this.subCommands.get(args[0])) != null) {
                String msg = subCommand.getInvalidArgsMessage(sender, subCommand.name, arguments);
                if (this.parent != null) {
                    sender.sendMessage(this.getInvalidArgsPrefix(sender, subCommand.name, arguments) + msg);
                    return true;
                }
            }
            sender.sendMessage(this.getInvalidArgsPrefix(sender, label, arguments) + this.getInvalidArgsMessage(sender, label, arguments));
            return true;
        }
        switch (this.usable) {
            case PLAYER: {
                CommandSender msg = sender;
                if (!(msg instanceof Player)) {
                    sender.sendMessage(this.getInvalidSenderMessage(this.usable));
                    return true;
                }
                Player plr = (Player)msg;
                if (!this.hasCooldown(plr)) break;
                sender.sendMessage(this.getCooldownMessage(plr));
                return true;
            }
            case CONSOLE: {
                if (sender instanceof ConsoleCommandSender) break;
                sender.sendMessage(this.getInvalidSenderMessage(this.usable));
                return true;
            }
            case COMMAND_BLOCK: {
                if (sender instanceof BlockCommandSender) break;
                sender.sendMessage(this.getInvalidSenderMessage(this.usable));
                return true;
            }
        }
        if (args.length == 0) {
            return this.execute(new Context<CommandSender>(sender, arguments));
        }
        SMPCommand subCommand = this.subCommands.get(args[0]);
        if (subCommand != null) {
            return subCommand.onCommand(sender, command, label, List.of(args).subList(1, args.length).toArray(new String[0]));
        }
        boolean res = this.execute(new Context<CommandSender>(sender, arguments));
        if (res && (successMessage = this.getSuccessMessage(sender, label, arguments)) != null) {
            sender.sendMessage(successMessage);
        }
        return res;
    }

    public final List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        List<ArgumentWrapper> sub2;
        SMPCommand cmd;
        ArrayList<String> out = new ArrayList<String>();
        if (strings.length > 0 && (cmd = this.subCommands.get(strings[0])) != null) {
            String[] subArgs = new String[strings.length - 1];
            System.arraycopy(strings, 1, subArgs, 0, subArgs.length);
            out.addAll(cmd.onTabComplete(commandSender, command, s, subArgs));
            return out;
        }
        this.subCommands.forEach((key, sub) -> out.add((String)key));
        if (strings.length - 1 > this.args.size()) {
            ArrayList sub22 = new ArrayList();
        } else {
            sub2 = this.args.subList(Math.max(0, strings.length - 1), this.args.size());
        }
        Arguments arguments = new Arguments(commandSender, strings);
        Context<CommandSender> ctx = new Context<CommandSender>(commandSender, arguments);
        for (ArgumentWrapper argumentWrapper : sub2) {
            out.addAll(this.getCompatible(ctx, argumentWrapper));
            if (!argumentWrapper.getArgument().required()) continue;
            break;
        }
        return out;
    }

    private List<String> getCompatible(Context<?> ctx, ArgumentWrapper wrapper) {
        List<String> completion;
        ArrayList<String> compatible = new ArrayList<String>();
        Argument arg = wrapper.getArgument();
        if (wrapper.hasTabCompletion() && (completion = wrapper.getTabCompletion(ctx)) != null && !completion.isEmpty()) {
            return completion;
        }
        if (arg.type() == Player.class) {
            Bukkit.getOnlinePlayers().forEach(plr -> compatible.add(plr.getName()));
            return compatible;
        }
        if (arg.type() == OfflinePlayer.class) {
            Bukkit.getOnlinePlayers().forEach(plr -> compatible.add(plr.getName()));
            Arrays.stream(Bukkit.getOfflinePlayers()).forEach(plr -> compatible.add(plr.getName()));
            return compatible;
        }
        String[] border = this.getArgumentBorder((CommandSender)ctx.source(), arg);
        compatible.add(border[0].trim() + arg.name() + border[1]);
        return compatible;
    }

    public abstract boolean execute(Context<?> var1);

    public String getInvalidSenderMessage(CommandUsable usable) {
        return switch (usable) {
            case CommandUsable.PLAYER -> "\u00a7cYou must be a player to use this command.";
            case CommandUsable.CONSOLE -> "\u00a7cYou must be the console to use this command.";
            case CommandUsable.COMMAND_BLOCK -> "\u00a7cYou must be a command block to use this command.";
            case CommandUsable.ALL -> null;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public String getInvalidArgsPrefix(CommandSender sender, String label, Arguments args) {
        return "\u00a7cUsage: \u00a7f/";
    }

    public String getInvalidArgsMessage(CommandSender sender, String label, Arguments args) {
        return "Not yet implemented, sorry!";
    }

    public String getSuccessMessage(CommandSender sender, String label, Arguments args) {
        return null;
    }

    public String getNoPermissionMessage(CommandSender sender) {
        return "\u00a7cYou do not have permission to use this command.";
    }

    public String getCooldownMessage(Player plr) {
        return "\u00a7cYou must wait &4" + this.getCooldown(plr) / 1000L + " &cseconds before using this command again.";
    }

    public final void setArgs(Argument ... args) {
        this.args = Stream.of(args).map(ArgumentWrapper::new).toList();
    }

    public final SMPCommand registerSubCommands(SMPCommand ... commands) {
        for (SMPCommand sub : commands) {
            this.subCommands.put(sub.getName(), sub);
            sub.parent = this;
        }
        return this;
    }

    public final SMPCommand setUsable(CommandUsable usable) {
        if (usable != null) {
            this.usable = usable;
        }
        return this;
    }

    public final SMPCommand setCooldown(UUID id, long cooldown) {
        this.cooldowns.put(id, cooldown);
        return this;
    }

    public final SMPCommand addCooldown(UUID id, long cooldown) {
        this.cooldowns.put(id, this.cooldowns.getOrDefault(id, 0L) + cooldown);
        return this;
    }

    public final SMPCommand subtractCooldown(UUID id, long cooldown) {
        this.cooldowns.put(id, this.cooldowns.getOrDefault(id, 0L) - cooldown);
        return this;
    }

    public final long getCooldown(UUID id) {
        return this.cooldowns.getOrDefault(id, 0L);
    }

    public final boolean hasCooldown(UUID id) {
        return this.cooldowns.getOrDefault(id, 0L) > 0L;
    }

    public final SMPCommand setCooldown(Player player, long cooldown) {
        return this.setCooldown(player.getUniqueId(), cooldown);
    }

    public final SMPCommand addCooldown(Player player, long cooldown) {
        return this.addCooldown(player.getUniqueId(), cooldown);
    }

    public final SMPCommand subtractCooldown(Player player, long cooldown) {
        return this.subtractCooldown(player.getUniqueId(), cooldown);
    }

    public final boolean hasCooldown(Player player) {
        return this.hasCooldown(player.getUniqueId());
    }

    public final long getCooldown(Player player) {
        return this.getCooldown(player.getUniqueId());
    }

    public final SMPCommand clearCooldowns() {
        this.cooldowns.clear();
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public final String getPath(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (ArgumentWrapper wrapper : this.args) {
            Argument argument = wrapper.getArgument();
            String[] border = this.getArgumentBorder(sender, argument);
            if (!argument.required()) {
                sb.append(border[0]).append(argument.name()).append(border[1]);
                continue;
            }
            sb.append(" <").append(argument.name()).append(">");
        }
        return sb.toString();
    }

    public final String getPermission() {
        return this.permission;
    }

    public final void setPermission(String permission) {
        this.permission = permission;
    }

    private String[] getArgumentBorder(CommandSender sender, Argument argument) {
        OptionalFor optionalFor = argument.optionalFor();
        if (optionalFor == OptionalFor.ALL) {
            return new String[]{" [", "]"};
        }
        if (sender instanceof ConsoleCommandSender && optionalFor != OptionalFor.CONSOLE) {
            return new String[]{" <", ">"};
        }
        if (sender instanceof Player && optionalFor != OptionalFor.PLAYER) {
            return new String[]{" <", ">"};
        }
        if (sender instanceof BlockCommandSender && optionalFor != OptionalFor.COMMAND_BLOCK) {
            return new String[]{" <", ">"};
        }
        return new String[]{" [", "]"};
    }

    public final List<String> getPaths() {
        return this.getPath("", 0);
    }

    private List<String> getPath(String initial, int start) {
        ArrayList<String> paths = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(initial);
        for (int i = start; i < this.args.size(); ++i) {
            ArgumentWrapper wrapper = this.args.get(i);
            Argument argument = wrapper.getArgument();
            if (!argument.required()) {
                String s = sb + " <" + argument.name() + ">";
                sb.append(" [").append(argument.name()).append("]");
                paths.addAll(this.getPath(s, i + 1));
                continue;
            }
            sb.append(" <").append(argument.name()).append(">");
        }
        paths.add(sb.toString());
        return paths;
    }
}

