/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.listeners;

import java.util.Objects;
import me.ikevoodoo.lssmp.config.MainConfig;
import me.ikevoodoo.lssmp.config.bans.BanConfig;
import me.ikevoodoo.lssmp.config.bans.BanTimeData;
import me.ikevoodoo.lssmp.utils.Util;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.events.PlayerPreDeathEvent;
import me.ikevoodoo.smpcore.events.TotemCheckEvent;
import me.ikevoodoo.smpcore.handlers.EliminationData;
import me.ikevoodoo.smpcore.listeners.SMPListener;
import me.ikevoodoo.smpcore.utils.StringUtils;
import me.ikevoodoo.smpcore.utils.health.HealthSetResult;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PlayerPreDeathListener
extends SMPListener {
    public PlayerPreDeathListener(SMPPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void on(PlayerPreDeathEvent event) {
        Entity entity;
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!MainConfig.Elimination.allowSelfElimination && Objects.equals(player, event.getKiller())) {
            return;
        }
        if (!MainConfig.Elimination.isWorldAllowed(world)) {
            return;
        }
        double hearts = this.getPlugin().getHealthHelper().getMaxHearts((LivingEntity)player);
        if (hearts <= MainConfig.Elimination.getMin()) {
            if (MainConfig.Elimination.banAtMinHealth) {
                this.eliminate(player);
            }
            return;
        }
        if (event.hasKiller() && (entity = event.getKiller()) instanceof Player) {
            Player killer = (Player)entity;
            this.handlePlayerKill(player, killer);
            return;
        }
        if (!MainConfig.Elimination.environmentStealsHearts) {
            return;
        }
        this.handleEnvironmentKill(player);
    }

    @EventHandler
    public void on(TotemCheckEvent event) {
        if (MainConfig.Elimination.totemWorksInInventory) {
            event.setHasTotem(event.getInventory().contains(Material.TOTEM_OF_UNDYING));
        }
    }

    private void eliminate(Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> {
            String banMessage;
            if (this.getPlugin().getEliminationHandler().isEliminated(player)) {
                return;
            }
            BanTimeData banData = BanConfig.INSTANCE.findHighest((Permissible)player);
            long standardBanTime = StringUtils.parseBanTime(MainConfig.Elimination.Bans.banTime);
            String standardBanMessage = MainConfig.Elimination.Bans.banMessage;
            long banTime = banData == null ? standardBanTime : banData.time();
            String string = banMessage = banData == null ? standardBanMessage : banData.banMessage();
            if (MainConfig.Elimination.Bans.broadcastBan) {
                String standardBroadcastMessage = MainConfig.Elimination.Bans.broadcastMessage;
                String broadcastMessage = banData == null ? standardBroadcastMessage : banData.broadcastBanMessage();
                Bukkit.broadcastMessage((String)broadcastMessage.replace("%player%", player.getDisplayName()));
            }
            if (MainConfig.Elimination.Bans.useBanTime) {
                EliminationData data = banData == null ? EliminationData.infiniteTime() : new EliminationData(banMessage, banTime);
                this.getPlugin().getEliminationHandler().eliminate(player, data);
            } else {
                this.getPlugin().getEliminationHandler().eliminate(player, EliminationData.infiniteTime(banMessage));
            }
            player.kickPlayer(MainConfig.Elimination.Bans.banMessage);
        }, 1L);
    }

    private void handleEnvironmentKill(Player player) {
        HealthSetResult setResult;
        if (MainConfig.Elimination.alwaysDropHearts || MainConfig.Elimination.environmentDropHearts) {
            Util.drop(this.getPlugin().getItem("heart_item").orElseThrow().getItemStack(), player.getEyeLocation());
        }
        if ((setResult = this.getPlugin().getHealthHelper().decreaseMaxHealthIfOver((LivingEntity)player, MainConfig.Elimination.getEnvironmentHeartScale(), MainConfig.Elimination.getMin())).newHealth() <= MainConfig.Elimination.getMin()) {
            this.eliminate(player);
        }
    }

    private void handlePlayerKill(Player player, Player killer) {
        Util.increaseOrDrop(MainConfig.Elimination.getHeartScale(), MainConfig.Elimination.getMax(), (LivingEntity)killer, player.getEyeLocation(), this.getPlugin());
        HealthSetResult result = this.getPlugin().getHealthHelper().decreaseMaxHealthIfOver((LivingEntity)player, MainConfig.Elimination.getHeartScale(), MainConfig.Elimination.getMin());
        if (result.newHealth() <= MainConfig.Elimination.getMin()) {
            this.eliminate(player);
        }
    }
}

