/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.language;

import dev.refinedtech.configlang.ConfigLang;
import dev.refinedtech.configlang.ConfigSection;
import dev.refinedtech.configlang.ConfigStructure;
import dev.refinedtech.configlang.scope.Scope;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.senders.CustomSender;
import me.ikevoodoo.smpcore.senders.SenderBuilder;
import me.ikevoodoo.smpcore.shared.PluginProvider;
import me.ikevoodoo.smpcore.utils.ClassUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class Language
extends PluginProvider {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\{\\{(.+?)\\}\\}");
    private final ConfigLang lang = new ConfigLang();

    public Language(SMPPlugin plugin) {
        super(plugin);
        this.lang.setErrorLogger(this.getPlugin().getLogger());
        this.lang.submit(new ConfigStructure("execute", new ConfigStructure[]{ConfigStructure.keyStructure("command"), ConfigStructure.keyStructure("as")}){

            @Override
            protected Object run(ConfigSection section, Scope scope, Object ... args) {
                Player player;
                String command = String.valueOf(Language.this.getVar(section, "command", scope, args));
                String sender = String.valueOf(Language.this.getVar(section, "as", scope, args));
                boolean logToSender = section.get("log", true);
                ConsoleCommandSender commandSender = Bukkit.getConsoleSender();
                if (sender.toLowerCase(Locale.ROOT).equalsIgnoreCase("console")) {
                    commandSender = Bukkit.getConsoleSender();
                }
                if ((player = Bukkit.getPlayer((String)sender)) != null) {
                    commandSender = player;
                }
                if (logToSender) {
                    Bukkit.dispatchCommand((CommandSender)commandSender, (String)command);
                } else {
                    Bukkit.dispatchCommand((CommandSender)SenderBuilder.createNewSender(CustomSender.as().noLog().sender((CommandSender)commandSender)), (String)command);
                }
                return null;
            }
        });
        this.lang.submit(new ConfigStructure("condition", true, new ConfigStructure[0]){

            @Override
            public boolean returnsData() {
                return true;
            }

            @Override
            protected Object run(ConfigSection section, Scope scope, Object ... objects) {
                AtomicBoolean res = new AtomicBoolean(true);
                Language.this.lang.executeChildren(section, scope, new Object[0]).forEach(result -> {
                    Object bool$temp = result;
                    if (bool$temp instanceof Boolean) {
                        Boolean bool = (Boolean)bool$temp;
                        res.set(res.get() && bool != false);
                    }
                });
                return res.get();
            }
        });
        this.lang.submit(new ConfigStructure("operation", new ConfigStructure[]{ConfigStructure.keyStructure("left"), ConfigStructure.keyStructure("operator"), ConfigStructure.keyStructure("right")}){

            @Override
            public boolean returnsData() {
                return true;
            }

            @Override
            protected Object run(ConfigSection section, Scope scope, Object ... args) {
                Object left = Language.this.getVar(section, "left", scope, args);
                Object right = Language.this.getVar(section, "right", scope, args);
                String operator = String.valueOf(Language.this.lang.getData(section, "operator", scope, args));
                if (left == null || right == null) {
                    return false;
                }
                if (ClassUtils.is(left, Number.class) && ClassUtils.is(right, Number.class)) {
                    double leftDouble = ((Number)left).doubleValue();
                    double rightDouble = ((Number)right).doubleValue();
                    int leftInt = ((Number)left).intValue();
                    int rightInt = ((Number)right).intValue();
                    return switch (operator) {
                        case "*" -> Double.valueOf(leftDouble * rightDouble);
                        case "/" -> Double.valueOf(leftDouble / rightDouble);
                        case "%" -> Double.valueOf(leftDouble % rightDouble);
                        case "+" -> Double.valueOf(leftDouble + rightDouble);
                        case "-" -> Double.valueOf(leftDouble - rightDouble);
                        case "<<" -> Integer.valueOf(leftInt << rightInt);
                        case ">>" -> Integer.valueOf(leftInt >> rightInt);
                        case ">>>" -> Integer.valueOf(leftInt >>> rightInt);
                        case "<" -> leftDouble < rightDouble;
                        case ">" -> leftDouble > rightDouble;
                        case "<=" -> leftDouble <= rightDouble;
                        case ">=" -> leftDouble >= rightDouble;
                        default -> false;
                    };
                }
                if (ClassUtils.is(left, Boolean.class) && ClassUtils.is(right, Boolean.class)) {
                    return switch (operator) {
                        case "&" -> (Boolean)left & (Boolean)right;
                        case "^" -> (Boolean)left ^ (Boolean)right;
                        case "|" -> (Boolean)left | (Boolean)right;
                        case "&&" -> (Boolean)left != false && (Boolean)right != false;
                        case "||" -> (Boolean)left != false || (Boolean)right != false;
                        default -> false;
                    };
                }
                return switch (operator) {
                    case "==" -> left == right;
                    case "!=" -> left != right;
                    case "===" -> (left.getClass().isAssignableFrom(right.getClass()) || right.getClass().isAssignableFrom(left.getClass())) && left.equals(right);
                    case "+" -> String.valueOf(left) + right;
                    default -> false;
                };
            }
        });
        this.lang.submit(new ConfigStructure("if", new ConfigStructure[]{this.lang.get("condition").orElseThrow()}){

            @Override
            protected Object run(ConfigSection section, Scope scope, Object ... objects) {
                Boolean bool;
                Object res = Language.this.lang.execute(section.getConfigSection("condition").orElseThrow(), scope, objects);
                Object object = res;
                if (object instanceof Boolean && (bool = (Boolean)object).booleanValue() && section.isConfigSection("then")) {
                    Language.this.lang.executeChildrenRecursive(section.getConfigSection("then").orElseThrow(), scope, objects);
                } else if (section.isConfigSection("else")) {
                    Language.this.lang.executeChildrenRecursive(section.getConfigSection("else").orElseThrow(), scope, objects);
                }
                return null;
            }
        });
    }

    public void execute(ConfigSection section, Scope scope, Object ... args) {
        this.lang.executeChildrenRecursive(section, scope, args);
    }

    private Object getVar(ConfigSection section, String key, Scope scope, Object ... args) {
        List list;
        Object obj = this.lang.getData(section, key, scope, args);
        Object object = obj;
        if (object instanceof List && (list = (List)object).isEmpty()) {
            obj = section.getObject(key).orElse(null);
        }
        if ((object = obj) instanceof String) {
            String text = (String)object;
            Matcher matcher = VAR_PATTERN.matcher(text);
            while (matcher.find()) {
                String var = matcher.group(1);
                Optional<Object> opt = scope.variables().parseVariableRaw(var);
                if (!opt.isPresent()) continue;
                text = matcher.replaceFirst(String.valueOf(opt.get()));
                matcher.reset(text);
            }
            return text;
        }
        return obj;
    }
}

