/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.items;

import me.ikevoodoo.lssmp.config.ItemConfig;
import me.ikevoodoo.lssmp.config.MainConfig;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.callbacks.chat.ChatTransactionListener;
import me.ikevoodoo.smpcore.commands.arguments.parsers.ParserRegistry;
import me.ikevoodoo.smpcore.items.CustomItem;
import me.ikevoodoo.smpcore.items.ItemClickResult;
import me.ikevoodoo.smpcore.items.ItemClickState;
import me.ikevoodoo.smpcore.text.messaging.MessageBuilder;
import me.ikevoodoo.smpcore.utils.Pair;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class ReviveBeacon
extends CustomItem {
    public ReviveBeacon(SMPPlugin plugin) {
        super(plugin, "revive_beacon", MessageBuilder.messageOf("\u00a7c\u00a7lRevive Beacon"));
        this.addKey("beacon").setDecreaseOnUse(true).bindConfig("items.beacon").bindConfigOptions("beaconRecipe.yml", "options").setRecipeFile("beaconRecipe.yml").reload();
    }

    @Override
    public ItemStack createItem(Player player) {
        return new ItemStack(this.getRecipeOptions().mat());
    }

    @Override
    public Pair<NamespacedKey, Recipe> createRecipe() {
        this.unlockOnObtain(this.getRecipeData().materials());
        return new Pair<NamespacedKey, Recipe>(this.makeKey("revive_beacon_recipe"), this.getRecipeData().recipe());
    }

    @Override
    public ItemClickResult onClick(final Player player, ItemStack itemStack, Action action) {
        if (this.getPlugin().getChatInputHandler().hasListener(player)) {
            return new ItemClickResult(ItemClickState.FAIL, true);
        }
        if (ItemConfig.ReviveBeacon.Options.useMenu) {
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 0.5f, 2.0f);
            this.getPlugin().getMenuHandler().get("lssmp_revive_beacon_menu").open(player);
            return new ItemClickResult(ItemClickState.IGNORE, true);
        }
        this.getPlugin().getChatInputHandler().onCancellableInput(player, new ChatTransactionListener(){

            @Override
            public boolean onChat(String message) {
                Player plr = ParserRegistry.get(Player.class).parse((CommandSender)player, message);
                if (plr == null) {
                    OfflinePlayer offlinePlayer = ParserRegistry.get(OfflinePlayer.class).parse((CommandSender)player, message);
                    if (!offlinePlayer.hasPlayedBefore()) {
                        player.sendMessage(MainConfig.Messages.Errors.notFound.replace("%s", "Player"));
                        return false;
                    }
                    ReviveBeacon.this.getPlugin().getEliminationHandler().reviveOffline(offlinePlayer);
                    player.sendMessage(ItemConfig.ReviveBeacon.Messages.revivedPlayer.replace("%s", String.valueOf(offlinePlayer.getName())));
                    return true;
                }
                ReviveBeacon.this.getPlugin().getEliminationHandler().revive(plr);
                player.sendMessage(ItemConfig.ReviveBeacon.Messages.revivedPlayer.replace("%s", plr.getDisplayName()));
                return true;
            }

            @Override
            public void onComplete(boolean success) {
                if (!success) {
                    CustomItem.give(player, ReviveBeacon.this.getPlugin().getItem("revive_beacon").orElseThrow());
                }
            }
        }, ItemConfig.ReviveBeacon.Messages.cancelMessage, ItemConfig.ReviveBeacon.Messages.cancelled, ItemConfig.ReviveBeacon.Messages.useMessage);
        return new ItemClickResult(ItemClickState.SUCCESS, true);
    }

    @Override
    public boolean onDrop(Player player, ItemStack itemStack) {
        return false;
    }
}

