/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.lssmp.commands.eliminate;

import java.util.List;
import me.ikevoodoo.lssmp.commands.eliminate.EliminateAllCommand;
import me.ikevoodoo.lssmp.config.CommandConfig;
import me.ikevoodoo.lssmp.config.MainConfig;
import me.ikevoodoo.lssmp.config.bans.BanConfig;
import me.ikevoodoo.lssmp.config.bans.BanTimeData;
import me.ikevoodoo.smpcore.SMPPlugin;
import me.ikevoodoo.smpcore.commands.Context;
import me.ikevoodoo.smpcore.commands.SMPCommand;
import me.ikevoodoo.smpcore.handlers.EliminationData;
import me.ikevoodoo.smpcore.utils.StringUtils;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class EliminateCommand
extends SMPCommand {
    public EliminateCommand(SMPPlugin plugin) {
        super(plugin, CommandConfig.EliminateCommand.name, CommandConfig.EliminateCommand.perms);
        this.registerSubCommands(new EliminateAllCommand(plugin));
    }

    @Override
    public boolean execute(Context<?> context) {
        if (context.args().isEmpty()) {
            context.source().sendMessage(MainConfig.Messages.Errors.specifyAtLeastOne.replace("%s", "player"));
            return true;
        }
        List<Player> players = context.args().getAll(Player.class);
        String defaultBanMessage = MainConfig.Elimination.Bans.banMessage;
        long standardBanTime = StringUtils.parseBanTime(MainConfig.Elimination.Bans.banTime);
        for (Player player : players) {
            BanTimeData data = BanConfig.INSTANCE.findHighest((Permissible)player);
            String banMessage = data == null ? defaultBanMessage : data.banMessage();
            long time = data == null ? standardBanTime : data.time();
            this.getPlugin().getEliminationHandler().eliminate(player, new EliminationData(banMessage, time));
            player.kickPlayer(banMessage);
        }
        context.source().sendMessage(CommandConfig.EliminateCommand.Messages.eliminatedPlayers.replace("%s", String.valueOf(players.size())));
        return true;
    }
}

