/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.juerr.traces;

import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import me.ikevoodoo.juerr.UserError;
import me.ikevoodoo.juerr.traces.StackTraceCause;
import me.ikevoodoo.juerr.traces.StackTraceHelper;
import me.ikevoodoo.juerr.traces.StackTraceLine;
import me.ikevoodoo.juerr.traces.StackTraceMode;

public class StackTraceError {
    private static final HashMap<Class<? extends Throwable>, BiConsumer<Throwable, UserError>> ERROR_HANDLERS = new HashMap();
    private final UserError error;

    public StackTraceError(UserError error) {
        this.error = error;
    }

    public void apply(Throwable throwable) {
        for (StackTraceElement element : throwable.getStackTrace()) {
            String className = element.getClassName();
            if (className.contains(".")) {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            className = className.replace("$", ".");
            this.error.addReason(String.format("%s.%s(%s:%s)", className, element.getMethodName(), element.getFileName(), element.getLineNumber()));
        }
        BiConsumer<Throwable, UserError> consumer = ERROR_HANDLERS.get(throwable.getClass());
        if (consumer != null) {
            consumer.accept(throwable, this.error);
        }
    }

    static {
        ERROR_HANDLERS.put(NullPointerException.class, (ex, error) -> {
            List<StackTraceLine> lines = StackTraceHelper.getInvolved(ex);
            StackTraceCause cause = StackTraceHelper.getCause(lines.get(0).clazz().get(), lines);
            error.addHelp(cause.generateExplanation(StackTraceMode.TRIED_TO_CALL, (Throwable)ex));
            error.addHelp(cause.generateHelp(StackTraceMode.TRIED_TO_CALL, (Throwable)ex));
            error.addHelp(cause.generateHelp(StackTraceMode.CHECK, (Throwable)ex));
        });
        ERROR_HANDLERS.put(RuntimeException.class, (ex, error) -> {
            List<StackTraceLine> lines = StackTraceHelper.getInvolved(ex);
            StackTraceCause cause = StackTraceHelper.getCause(lines.get(0).clazz().get(), lines);
            error.addHelp(cause.generateHelp(StackTraceMode.TRY_CATCH, (Throwable)ex));
        });
    }
}

