/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.juerr;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.ikevoodoo.juerr.ExceptionRunnable;
import me.ikevoodoo.juerr.PrintStreamPrinter;
import me.ikevoodoo.juerr.Printer;
import me.ikevoodoo.juerr.UserErrorEntry;
import me.ikevoodoo.juerr.traces.StackTraceError;

public class UserError {
    private static final PrintStreamPrinter streamPrinter = new PrintStreamPrinter(System.err);
    private final String message;
    private final List<UserErrorEntry> help;
    private final List<UserErrorEntry> reasons;

    public UserError(String message) {
        this.message = message;
        this.help = new ArrayList<UserErrorEntry>();
        this.reasons = new ArrayList<UserErrorEntry>();
    }

    public static void setExceptionHandler() {
        UserError.setExceptionHandler(Thread.currentThread());
    }

    public static void setAllExceptionHandler() {
        Thread.getAllStackTraces().forEach((thread, stackTraceElements) -> UserError.setExceptionHandler(thread));
    }

    public static void setExceptionHandler(Thread thread) {
        thread.setUncaughtExceptionHandler((t, e) -> UserError.fromStacktrace(e).printAll(String.format("[Thread %s] Uncaught: ", t.getName())));
    }

    public static Optional<UserError> from(ExceptionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            return Optional.of(UserError.from(throwable.getLocalizedMessage()));
        }
        return Optional.empty();
    }

    public static UserError from(String message) {
        return new UserError(message);
    }

    public static UserError intoUserError(Throwable throwable) {
        return new UserError(throwable.getLocalizedMessage());
    }

    public static Optional<UserError> fromStacktrace(ExceptionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            return Optional.of(UserError.fromStacktrace(throwable));
        }
        return Optional.empty();
    }

    public static UserError fromStacktrace(Throwable throwable) {
        UserError error = new UserError(String.format("%s: %s", throwable.getClass().getSimpleName(), throwable.getLocalizedMessage()));
        StackTraceError stackTraceError = new StackTraceError(error);
        stackTraceError.apply(throwable);
        return error;
    }

    public UserError printAll(String prefix) {
        return this.printAll(streamPrinter, prefix);
    }

    public UserError printAll(Printer<?> printer, String prefix) {
        this.print(printer, prefix);
        return this;
    }

    public UserError addHelp(String help) {
        return this.addHelp(UserErrorEntry.from(help.split("\n")));
    }

    public UserError addReason(String reason) {
        return this.addReason(UserErrorEntry.from(reason.split("\n")));
    }

    public UserError addHelp(UserErrorEntry help) {
        this.help.add(help);
        return this;
    }

    public UserError addReason(UserErrorEntry reason) {
        this.reasons.add(reason);
        return this;
    }

    public String message() {
        return this.message;
    }

    public List<UserErrorEntry> reasons() {
        return this.reasons;
    }

    public List<UserErrorEntry> help() {
        return this.help;
    }

    private void print(Printer<?> printer, String prefix) {
        printer.printfln("%s%s", prefix, this.message);
        this.printList(printer, this.reasons, " - caused by: ", "     |        ");
        this.printList(printer, this.help, " + help: ", "     |   ");
    }

    private void printList(Printer<?> printer, List<UserErrorEntry> list, String prefix, String joiner) {
        if (list.isEmpty()) {
            return;
        }
        UserErrorEntry first = this.findFirstWithLines(list);
        if (first == null) {
            return;
        }
        printer.printfln("%s%s", prefix, first.lines().get(0));
        for (int i = 1; i < first.lines().size(); ++i) {
            printer.printfln("%s%s", joiner, first.lines().get(i));
        }
        int index = list.indexOf(first) + 1;
        list.subList(index, list.size()).forEach(entry -> entry.lines().forEach(line -> printer.printfln("%s%s", joiner, line)));
    }

    private UserErrorEntry findFirstWithLines(List<UserErrorEntry> list) {
        for (UserErrorEntry entry : list) {
            if (entry.lines().size() <= 0) continue;
            return entry;
        }
        return null;
    }
}

