/*
 * Decompiled with CFR 0.152.
 */
package me.ikevoodoo.juerr;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;

public class ProjectInfo {
    private static final HashMap<Class<?>, List<Class<?>>> CLASSES = new HashMap();

    private ProjectInfo() {
    }

    public static void load(Class<?> clazz) throws URISyntaxException, IOException {
        Path root;
        if (ProjectInfo.isLoaded(clazz)) {
            return;
        }
        Package pack = clazz.getPackage();
        if (pack == null) {
            ArrayList classes = new ArrayList();
            classes.add(clazz);
            CLASSES.put(clazz, classes);
            return;
        }
        String packageName = pack.getName();
        String packagePath = packageName.replace('.', '/');
        URL resource = clazz.getClassLoader().getResource(packagePath);
        if (resource == null) {
            return;
        }
        URI pkg = resource.toURI();
        ArrayList classes = new ArrayList();
        if (pkg.getScheme().equals("jar")) {
            try {
                root = FileSystems.getFileSystem(pkg).getPath(packagePath, new String[0]);
            }
            catch (FileSystemNotFoundException e) {
                root = FileSystems.newFileSystem(pkg, Collections.emptyMap()).getPath(packagePath, new String[0]);
            }
        } else {
            root = Paths.get(pkg);
        }
        try (Stream<Path> paths = Files.walk(root, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String path = file.toString().replace("/", ".");
                String name = path.substring(path.indexOf(packageName), path.length() - 6);
                try {
                    classes.add(Class.forName(name));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            });
        }
        CLASSES.put(clazz, classes);
    }

    public static List<Class<?>> getClasses(Class<?> clazz) {
        return CLASSES.get(clazz);
    }

    public static boolean isLoaded(Class<?> clazz) {
        return !CLASSES.isEmpty() && CLASSES.containsKey(clazz);
    }
}

