/*
 * Decompiled with CFR 0.152.
 */
package dev.refinedtech.configlang;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;

public abstract class ConfigSection {
    public abstract String getName();

    public abstract String getPath();

    public abstract boolean isConfigSection(String var1);

    public abstract Optional<ConfigSection> getConfigSection(String var1);

    public abstract Set<String> getKeys(boolean var1);

    public abstract boolean contains(String var1);

    public abstract <T> Optional<T> get(String var1);

    public abstract <T> T get(String var1, T var2);

    public abstract Optional<Object> getObject(String var1);

    public abstract Object getObject(String var1, Object var2);

    public abstract void set(String var1, Object var2);

    public abstract void save(File var1) throws IOException;

    public abstract void load(File var1) throws IOException;

    public String treeString(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(" (Section)");
        sb.append("\n");
        ++depth;
        for (String key : this.getKeys(false)) {
            sb.append("  ".repeat(Math.max(0, depth)));
            sb.append(key);
            if (this.isConfigSection(key)) {
                sb.append(" \u2193 ");
                sb.append("\n");
                sb.append("  ".repeat(Math.max(0, depth) + 1));
                sb.append(this.getConfigSection(key).orElseThrow().treeString(depth + 1));
                continue;
            }
            sb.append(" = ");
            sb.append(this.getObject(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    public final String treeString() {
        return this.treeString(0);
    }
}

